package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "enableAccessTokenIssuance", 
    "enableIdTokenIssuance"})
@JsonInclude(Include.NON_NULL)
public class ImplicitGrantSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("enableAccessTokenIssuance")
    protected Boolean enableAccessTokenIssuance;

    @JsonProperty("enableIdTokenIssuance")
    protected Boolean enableIdTokenIssuance;

    protected ImplicitGrantSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.implicitGrantSettings";
    }

    @Property(name="enableAccessTokenIssuance")
    @JsonIgnore
    public Optional<Boolean> getEnableAccessTokenIssuance() {
        return Optional.ofNullable(enableAccessTokenIssuance);
    }

    public ImplicitGrantSettings withEnableAccessTokenIssuance(Boolean enableAccessTokenIssuance) {
        ImplicitGrantSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.implicitGrantSettings");
        _x.enableAccessTokenIssuance = enableAccessTokenIssuance;
        return _x;
    }

    @Property(name="enableIdTokenIssuance")
    @JsonIgnore
    public Optional<Boolean> getEnableIdTokenIssuance() {
        return Optional.ofNullable(enableIdTokenIssuance);
    }

    public ImplicitGrantSettings withEnableIdTokenIssuance(Boolean enableIdTokenIssuance) {
        ImplicitGrantSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.implicitGrantSettings");
        _x.enableIdTokenIssuance = enableIdTokenIssuance;
        return _x;
    }

    public ImplicitGrantSettings withUnmappedField(String name, Object value) {
        ImplicitGrantSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean enableAccessTokenIssuance;
        private Boolean enableIdTokenIssuance;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder enableAccessTokenIssuance(Boolean enableAccessTokenIssuance) {
            this.enableAccessTokenIssuance = enableAccessTokenIssuance;
            this.changedFields = changedFields.add("enableAccessTokenIssuance");
            return this;
        }

        public Builder enableIdTokenIssuance(Boolean enableIdTokenIssuance) {
            this.enableIdTokenIssuance = enableIdTokenIssuance;
            this.changedFields = changedFields.add("enableIdTokenIssuance");
            return this;
        }

        public ImplicitGrantSettings build() {
            ImplicitGrantSettings _x = new ImplicitGrantSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.implicitGrantSettings";
            _x.enableAccessTokenIssuance = enableAccessTokenIssuance;
            _x.enableIdTokenIssuance = enableIdTokenIssuance;
            return _x;
        }
    }

    private ImplicitGrantSettings _copy() {
        ImplicitGrantSettings _x = new ImplicitGrantSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.enableAccessTokenIssuance = enableAccessTokenIssuance;
        _x.enableIdTokenIssuance = enableIdTokenIssuance;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ImplicitGrantSettings[");
        b.append("enableAccessTokenIssuance=");
        b.append(this.enableAccessTokenIssuance);
        b.append(", ");
        b.append("enableIdTokenIssuance=");
        b.append(this.enableIdTokenIssuance);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
