package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“IPv4 Range definition.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "lowerAddress", 
    "upperAddress"})
@JsonInclude(Include.NON_NULL)
public class IPv4Range extends IpRange implements ODataType {

    @JsonProperty("lowerAddress")
    protected String lowerAddress;

    @JsonProperty("upperAddress")
    protected String upperAddress;

    protected IPv4Range() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.iPv4Range";
    }

    /**
     * <i>“Lower address.”</i>
     * 
     * @return property lowerAddress
     */
    @Property(name="lowerAddress")
    @JsonIgnore
    public Optional<String> getLowerAddress() {
        return Optional.ofNullable(lowerAddress);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code lowerAddress}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Lower address.”</i>
     * 
     * @param lowerAddress
     *            new value of {@code lowerAddress} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lowerAddress} field changed
     */
    public IPv4Range withLowerAddress(String lowerAddress) {
        IPv4Range _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iPv4Range");
        _x.lowerAddress = lowerAddress;
        return _x;
    }

    /**
     * <i>“Upper address.”</i>
     * 
     * @return property upperAddress
     */
    @Property(name="upperAddress")
    @JsonIgnore
    public Optional<String> getUpperAddress() {
        return Optional.ofNullable(upperAddress);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code upperAddress}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Upper address.”</i>
     * 
     * @param upperAddress
     *            new value of {@code upperAddress} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code upperAddress} field changed
     */
    public IPv4Range withUpperAddress(String upperAddress) {
        IPv4Range _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iPv4Range");
        _x.upperAddress = upperAddress;
        return _x;
    }

    public IPv4Range withUnmappedField(String name, Object value) {
        IPv4Range _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderIPv4Range() {
        return new Builder();
    }

    public static final class Builder {
        private String lowerAddress;
        private String upperAddress;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Lower address.”</i>
         * 
         * @param lowerAddress
         *            value of {@code lowerAddress} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lowerAddress(String lowerAddress) {
            this.lowerAddress = lowerAddress;
            this.changedFields = changedFields.add("lowerAddress");
            return this;
        }

        /**
         * <i>“Upper address.”</i>
         * 
         * @param upperAddress
         *            value of {@code upperAddress} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder upperAddress(String upperAddress) {
            this.upperAddress = upperAddress;
            this.changedFields = changedFields.add("upperAddress");
            return this;
        }

        public IPv4Range build() {
            IPv4Range _x = new IPv4Range();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.iPv4Range";
            _x.lowerAddress = lowerAddress;
            _x.upperAddress = upperAddress;
            return _x;
        }
    }

    private IPv4Range _copy() {
        IPv4Range _x = new IPv4Range();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.lowerAddress = lowerAddress;
        _x.upperAddress = upperAddress;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IPv4Range[");
        b.append("lowerAddress=");
        b.append(this.lowerAddress);
        b.append(", ");
        b.append("upperAddress=");
        b.append(this.upperAddress);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
