package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "fqdn", 
    "isAzureAdJoined", 
    "isAzureAdRegistered", 
    "isHybridAzureDomainJoined", 
    "netBiosName", 
    "os", 
    "privateIpAddress", 
    "publicIpAddress", 
    "riskScore"})
@JsonInclude(Include.NON_NULL)
public class HostSecurityState implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("fqdn")
    protected String fqdn;

    @JsonProperty("isAzureAdJoined")
    protected Boolean isAzureAdJoined;

    @JsonProperty("isAzureAdRegistered")
    protected Boolean isAzureAdRegistered;

    @JsonProperty("isHybridAzureDomainJoined")
    protected Boolean isHybridAzureDomainJoined;

    @JsonProperty("netBiosName")
    protected String netBiosName;

    @JsonProperty("os")
    protected String os;

    @JsonProperty("privateIpAddress")
    protected String privateIpAddress;

    @JsonProperty("publicIpAddress")
    protected String publicIpAddress;

    @JsonProperty("riskScore")
    protected String riskScore;

    protected HostSecurityState() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.hostSecurityState";
    }

    @Property(name="fqdn")
    @JsonIgnore
    public Optional<String> getFqdn() {
        return Optional.ofNullable(fqdn);
    }

    public HostSecurityState withFqdn(String fqdn) {
        HostSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hostSecurityState");
        _x.fqdn = fqdn;
        return _x;
    }

    @Property(name="isAzureAdJoined")
    @JsonIgnore
    public Optional<Boolean> getIsAzureAdJoined() {
        return Optional.ofNullable(isAzureAdJoined);
    }

    public HostSecurityState withIsAzureAdJoined(Boolean isAzureAdJoined) {
        HostSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hostSecurityState");
        _x.isAzureAdJoined = isAzureAdJoined;
        return _x;
    }

    @Property(name="isAzureAdRegistered")
    @JsonIgnore
    public Optional<Boolean> getIsAzureAdRegistered() {
        return Optional.ofNullable(isAzureAdRegistered);
    }

    public HostSecurityState withIsAzureAdRegistered(Boolean isAzureAdRegistered) {
        HostSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hostSecurityState");
        _x.isAzureAdRegistered = isAzureAdRegistered;
        return _x;
    }

    @Property(name="isHybridAzureDomainJoined")
    @JsonIgnore
    public Optional<Boolean> getIsHybridAzureDomainJoined() {
        return Optional.ofNullable(isHybridAzureDomainJoined);
    }

    public HostSecurityState withIsHybridAzureDomainJoined(Boolean isHybridAzureDomainJoined) {
        HostSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hostSecurityState");
        _x.isHybridAzureDomainJoined = isHybridAzureDomainJoined;
        return _x;
    }

    @Property(name="netBiosName")
    @JsonIgnore
    public Optional<String> getNetBiosName() {
        return Optional.ofNullable(netBiosName);
    }

    public HostSecurityState withNetBiosName(String netBiosName) {
        HostSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hostSecurityState");
        _x.netBiosName = netBiosName;
        return _x;
    }

    @Property(name="os")
    @JsonIgnore
    public Optional<String> getOs() {
        return Optional.ofNullable(os);
    }

    public HostSecurityState withOs(String os) {
        HostSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hostSecurityState");
        _x.os = os;
        return _x;
    }

    @Property(name="privateIpAddress")
    @JsonIgnore
    public Optional<String> getPrivateIpAddress() {
        return Optional.ofNullable(privateIpAddress);
    }

    public HostSecurityState withPrivateIpAddress(String privateIpAddress) {
        HostSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hostSecurityState");
        _x.privateIpAddress = privateIpAddress;
        return _x;
    }

    @Property(name="publicIpAddress")
    @JsonIgnore
    public Optional<String> getPublicIpAddress() {
        return Optional.ofNullable(publicIpAddress);
    }

    public HostSecurityState withPublicIpAddress(String publicIpAddress) {
        HostSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hostSecurityState");
        _x.publicIpAddress = publicIpAddress;
        return _x;
    }

    @Property(name="riskScore")
    @JsonIgnore
    public Optional<String> getRiskScore() {
        return Optional.ofNullable(riskScore);
    }

    public HostSecurityState withRiskScore(String riskScore) {
        HostSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hostSecurityState");
        _x.riskScore = riskScore;
        return _x;
    }

    public HostSecurityState withUnmappedField(String name, Object value) {
        HostSecurityState _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String fqdn;
        private Boolean isAzureAdJoined;
        private Boolean isAzureAdRegistered;
        private Boolean isHybridAzureDomainJoined;
        private String netBiosName;
        private String os;
        private String privateIpAddress;
        private String publicIpAddress;
        private String riskScore;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder fqdn(String fqdn) {
            this.fqdn = fqdn;
            this.changedFields = changedFields.add("fqdn");
            return this;
        }

        public Builder isAzureAdJoined(Boolean isAzureAdJoined) {
            this.isAzureAdJoined = isAzureAdJoined;
            this.changedFields = changedFields.add("isAzureAdJoined");
            return this;
        }

        public Builder isAzureAdRegistered(Boolean isAzureAdRegistered) {
            this.isAzureAdRegistered = isAzureAdRegistered;
            this.changedFields = changedFields.add("isAzureAdRegistered");
            return this;
        }

        public Builder isHybridAzureDomainJoined(Boolean isHybridAzureDomainJoined) {
            this.isHybridAzureDomainJoined = isHybridAzureDomainJoined;
            this.changedFields = changedFields.add("isHybridAzureDomainJoined");
            return this;
        }

        public Builder netBiosName(String netBiosName) {
            this.netBiosName = netBiosName;
            this.changedFields = changedFields.add("netBiosName");
            return this;
        }

        public Builder os(String os) {
            this.os = os;
            this.changedFields = changedFields.add("os");
            return this;
        }

        public Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            this.changedFields = changedFields.add("privateIpAddress");
            return this;
        }

        public Builder publicIpAddress(String publicIpAddress) {
            this.publicIpAddress = publicIpAddress;
            this.changedFields = changedFields.add("publicIpAddress");
            return this;
        }

        public Builder riskScore(String riskScore) {
            this.riskScore = riskScore;
            this.changedFields = changedFields.add("riskScore");
            return this;
        }

        public HostSecurityState build() {
            HostSecurityState _x = new HostSecurityState();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.hostSecurityState";
            _x.fqdn = fqdn;
            _x.isAzureAdJoined = isAzureAdJoined;
            _x.isAzureAdRegistered = isAzureAdRegistered;
            _x.isHybridAzureDomainJoined = isHybridAzureDomainJoined;
            _x.netBiosName = netBiosName;
            _x.os = os;
            _x.privateIpAddress = privateIpAddress;
            _x.publicIpAddress = publicIpAddress;
            _x.riskScore = riskScore;
            return _x;
        }
    }

    private HostSecurityState _copy() {
        HostSecurityState _x = new HostSecurityState();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.fqdn = fqdn;
        _x.isAzureAdJoined = isAzureAdJoined;
        _x.isAzureAdRegistered = isAzureAdRegistered;
        _x.isHybridAzureDomainJoined = isHybridAzureDomainJoined;
        _x.netBiosName = netBiosName;
        _x.os = os;
        _x.privateIpAddress = privateIpAddress;
        _x.publicIpAddress = publicIpAddress;
        _x.riskScore = riskScore;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("HostSecurityState[");
        b.append("fqdn=");
        b.append(this.fqdn);
        b.append(", ");
        b.append("isAzureAdJoined=");
        b.append(this.isAzureAdJoined);
        b.append(", ");
        b.append("isAzureAdRegistered=");
        b.append(this.isAzureAdRegistered);
        b.append(", ");
        b.append("isHybridAzureDomainJoined=");
        b.append(this.isHybridAzureDomainJoined);
        b.append(", ");
        b.append("netBiosName=");
        b.append(this.netBiosName);
        b.append(", ");
        b.append("os=");
        b.append(this.os);
        b.append(", ");
        b.append("privateIpAddress=");
        b.append(this.privateIpAddress);
        b.append(", ");
        b.append("publicIpAddress=");
        b.append(this.publicIpAddress);
        b.append(", ");
        b.append("riskScore=");
        b.append(this.riskScore);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
