package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DeviceGuardLocalSystemAuthorityCredentialGuardState;
import odata.msgraph.client.beta.enums.DeviceGuardVirtualizationBasedSecurityHardwareRequirementState;
import odata.msgraph.client.beta.enums.DeviceGuardVirtualizationBasedSecurityState;


/**
 * <i>“Hardware information of a given device.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "batteryChargeCycles", 
    "batteryHealthPercentage", 
    "batterySerialNumber", 
    "cellularTechnology", 
    "deviceFullQualifiedDomainName", 
    "deviceGuardLocalSystemAuthorityCredentialGuardState", 
    "deviceGuardVirtualizationBasedSecurityHardwareRequirementState", 
    "deviceGuardVirtualizationBasedSecurityState", 
    "esimIdentifier", 
    "freeStorageSpace", 
    "imei", 
    "ipAddressV4", 
    "isEncrypted", 
    "isSharedDevice", 
    "isSupervised", 
    "manufacturer", 
    "meid", 
    "model", 
    "operatingSystemEdition", 
    "operatingSystemLanguage", 
    "operatingSystemProductType", 
    "osBuildNumber", 
    "phoneNumber", 
    "serialNumber", 
    "sharedDeviceCachedUsers", 
    "subnetAddress", 
    "subscriberCarrier", 
    "systemManagementBIOSVersion", 
    "totalStorageSpace", 
    "tpmManufacturer", 
    "tpmSpecificationVersion", 
    "tpmVersion", 
    "wifiMac"})
@JsonInclude(Include.NON_NULL)
public class HardwareInformation implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("batteryChargeCycles")
    protected Integer batteryChargeCycles;

    @JsonProperty("batteryHealthPercentage")
    protected Integer batteryHealthPercentage;

    @JsonProperty("batterySerialNumber")
    protected String batterySerialNumber;

    @JsonProperty("cellularTechnology")
    protected String cellularTechnology;

    @JsonProperty("deviceFullQualifiedDomainName")
    protected String deviceFullQualifiedDomainName;

    @JsonProperty("deviceGuardLocalSystemAuthorityCredentialGuardState")
    protected DeviceGuardLocalSystemAuthorityCredentialGuardState deviceGuardLocalSystemAuthorityCredentialGuardState;

    @JsonProperty("deviceGuardVirtualizationBasedSecurityHardwareRequirementState")
    protected DeviceGuardVirtualizationBasedSecurityHardwareRequirementState deviceGuardVirtualizationBasedSecurityHardwareRequirementState;

    @JsonProperty("deviceGuardVirtualizationBasedSecurityState")
    protected DeviceGuardVirtualizationBasedSecurityState deviceGuardVirtualizationBasedSecurityState;

    @JsonProperty("esimIdentifier")
    protected String esimIdentifier;

    @JsonProperty("freeStorageSpace")
    protected Long freeStorageSpace;

    @JsonProperty("imei")
    protected String imei;

    @JsonProperty("ipAddressV4")
    protected String ipAddressV4;

    @JsonProperty("isEncrypted")
    protected Boolean isEncrypted;

    @JsonProperty("isSharedDevice")
    protected Boolean isSharedDevice;

    @JsonProperty("isSupervised")
    protected Boolean isSupervised;

    @JsonProperty("manufacturer")
    protected String manufacturer;

    @JsonProperty("meid")
    protected String meid;

    @JsonProperty("model")
    protected String model;

    @JsonProperty("operatingSystemEdition")
    protected String operatingSystemEdition;

    @JsonProperty("operatingSystemLanguage")
    protected String operatingSystemLanguage;

    @JsonProperty("operatingSystemProductType")
    protected Integer operatingSystemProductType;

    @JsonProperty("osBuildNumber")
    protected String osBuildNumber;

    @JsonProperty("phoneNumber")
    protected String phoneNumber;

    @JsonProperty("serialNumber")
    protected String serialNumber;

    @JsonProperty("sharedDeviceCachedUsers")
    protected List<SharedAppleDeviceUser> sharedDeviceCachedUsers;

    @JsonProperty("sharedDeviceCachedUsers@nextLink")
    protected String sharedDeviceCachedUsersNextLink;

    @JsonProperty("subnetAddress")
    protected String subnetAddress;

    @JsonProperty("subscriberCarrier")
    protected String subscriberCarrier;

    @JsonProperty("systemManagementBIOSVersion")
    protected String systemManagementBIOSVersion;

    @JsonProperty("totalStorageSpace")
    protected Long totalStorageSpace;

    @JsonProperty("tpmManufacturer")
    protected String tpmManufacturer;

    @JsonProperty("tpmSpecificationVersion")
    protected String tpmSpecificationVersion;

    @JsonProperty("tpmVersion")
    protected String tpmVersion;

    @JsonProperty("wifiMac")
    protected String wifiMac;

    protected HardwareInformation() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.hardwareInformation";
    }

    /**
     * <i>“The number of charge cycles the device’s current battery has gone through. Valid
     * values 0 to 2147483647”</i>
     * 
     * @return property batteryChargeCycles
     */
    @Property(name="batteryChargeCycles")
    @JsonIgnore
    public Optional<Integer> getBatteryChargeCycles() {
        return Optional.ofNullable(batteryChargeCycles);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * batteryChargeCycles} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The number of charge cycles the device’s current battery has gone through. Valid
     * values 0 to 2147483647”</i>
     * 
     * @param batteryChargeCycles
     *            new value of {@code batteryChargeCycles} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code batteryChargeCycles} field changed
     */
    public HardwareInformation withBatteryChargeCycles(Integer batteryChargeCycles) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.batteryChargeCycles = batteryChargeCycles;
        return _x;
    }

    /**
     * <i>“The device’s current battery’s health percentage. Valid values 0 to 100”</i>
     * 
     * @return property batteryHealthPercentage
     */
    @Property(name="batteryHealthPercentage")
    @JsonIgnore
    public Optional<Integer> getBatteryHealthPercentage() {
        return Optional.ofNullable(batteryHealthPercentage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * batteryHealthPercentage} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The device’s current battery’s health percentage. Valid values 0 to 100”</i>
     * 
     * @param batteryHealthPercentage
     *            new value of {@code batteryHealthPercentage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code batteryHealthPercentage} field changed
     */
    public HardwareInformation withBatteryHealthPercentage(Integer batteryHealthPercentage) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.batteryHealthPercentage = batteryHealthPercentage;
        return _x;
    }

    /**
     * <i>“The serial number of the device’s current battery”</i>
     * 
     * @return property batterySerialNumber
     */
    @Property(name="batterySerialNumber")
    @JsonIgnore
    public Optional<String> getBatterySerialNumber() {
        return Optional.ofNullable(batterySerialNumber);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * batterySerialNumber} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The serial number of the device’s current battery”</i>
     * 
     * @param batterySerialNumber
     *            new value of {@code batterySerialNumber} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code batterySerialNumber} field changed
     */
    public HardwareInformation withBatterySerialNumber(String batterySerialNumber) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.batterySerialNumber = batterySerialNumber;
        return _x;
    }

    /**
     * <i>“Cellular technology of the device”</i>
     * 
     * @return property cellularTechnology
     */
    @Property(name="cellularTechnology")
    @JsonIgnore
    public Optional<String> getCellularTechnology() {
        return Optional.ofNullable(cellularTechnology);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * cellularTechnology} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Cellular technology of the device”</i>
     * 
     * @param cellularTechnology
     *            new value of {@code cellularTechnology} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cellularTechnology} field changed
     */
    public HardwareInformation withCellularTechnology(String cellularTechnology) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.cellularTechnology = cellularTechnology;
        return _x;
    }

    /**
     * <i>“Returns the fully qualified domain name of the device (if any). If the device is
     * not domain-joined, it returns an empty string.”</i>
     * 
     * @return property deviceFullQualifiedDomainName
     */
    @Property(name="deviceFullQualifiedDomainName")
    @JsonIgnore
    public Optional<String> getDeviceFullQualifiedDomainName() {
        return Optional.ofNullable(deviceFullQualifiedDomainName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceFullQualifiedDomainName} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Returns the fully qualified domain name of the device (if any). If the device is
     * not domain-joined, it returns an empty string.”</i>
     * 
     * @param deviceFullQualifiedDomainName
     *            new value of {@code deviceFullQualifiedDomainName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceFullQualifiedDomainName} field changed
     */
    public HardwareInformation withDeviceFullQualifiedDomainName(String deviceFullQualifiedDomainName) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.deviceFullQualifiedDomainName = deviceFullQualifiedDomainName;
        return _x;
    }

    /**
     * <i>“Local System Authority (LSA) credential guard status.”</i>
     * 
     * @return property deviceGuardLocalSystemAuthorityCredentialGuardState
     */
    @Property(name="deviceGuardLocalSystemAuthorityCredentialGuardState")
    @JsonIgnore
    public Optional<DeviceGuardLocalSystemAuthorityCredentialGuardState> getDeviceGuardLocalSystemAuthorityCredentialGuardState() {
        return Optional.ofNullable(deviceGuardLocalSystemAuthorityCredentialGuardState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceGuardLocalSystemAuthorityCredentialGuardState} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Local System Authority (LSA) credential guard status.”</i>
     * 
     * @param deviceGuardLocalSystemAuthorityCredentialGuardState
     *            new value of {@code deviceGuardLocalSystemAuthorityCredentialGuardState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceGuardLocalSystemAuthorityCredentialGuardState} field changed
     */
    public HardwareInformation withDeviceGuardLocalSystemAuthorityCredentialGuardState(DeviceGuardLocalSystemAuthorityCredentialGuardState deviceGuardLocalSystemAuthorityCredentialGuardState) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.deviceGuardLocalSystemAuthorityCredentialGuardState = deviceGuardLocalSystemAuthorityCredentialGuardState;
        return _x;
    }

    /**
     * <i>“Virtualization-based security hardware requirement status.”</i>
     * 
     * @return property deviceGuardVirtualizationBasedSecurityHardwareRequirementState
     */
    @Property(name="deviceGuardVirtualizationBasedSecurityHardwareRequirementState")
    @JsonIgnore
    public Optional<DeviceGuardVirtualizationBasedSecurityHardwareRequirementState> getDeviceGuardVirtualizationBasedSecurityHardwareRequirementState() {
        return Optional.ofNullable(deviceGuardVirtualizationBasedSecurityHardwareRequirementState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceGuardVirtualizationBasedSecurityHardwareRequirementState} field changed.
     * Field description below. The field name is also added to an internal map of
     * changed fields in the returned object so that when {@code this.patch()} is
     * called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Virtualization-based security hardware requirement status.”</i>
     * 
     * @param deviceGuardVirtualizationBasedSecurityHardwareRequirementState
     *            new value of {@code deviceGuardVirtualizationBasedSecurityHardwareRequirementState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceGuardVirtualizationBasedSecurityHardwareRequirementState} field changed
     */
    public HardwareInformation withDeviceGuardVirtualizationBasedSecurityHardwareRequirementState(DeviceGuardVirtualizationBasedSecurityHardwareRequirementState deviceGuardVirtualizationBasedSecurityHardwareRequirementState) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.deviceGuardVirtualizationBasedSecurityHardwareRequirementState = deviceGuardVirtualizationBasedSecurityHardwareRequirementState;
        return _x;
    }

    /**
     * <i>“Virtualization-based security status.”</i>
     * 
     * @return property deviceGuardVirtualizationBasedSecurityState
     */
    @Property(name="deviceGuardVirtualizationBasedSecurityState")
    @JsonIgnore
    public Optional<DeviceGuardVirtualizationBasedSecurityState> getDeviceGuardVirtualizationBasedSecurityState() {
        return Optional.ofNullable(deviceGuardVirtualizationBasedSecurityState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceGuardVirtualizationBasedSecurityState} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Virtualization-based security status.”</i>
     * 
     * @param deviceGuardVirtualizationBasedSecurityState
     *            new value of {@code deviceGuardVirtualizationBasedSecurityState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceGuardVirtualizationBasedSecurityState} field changed
     */
    public HardwareInformation withDeviceGuardVirtualizationBasedSecurityState(DeviceGuardVirtualizationBasedSecurityState deviceGuardVirtualizationBasedSecurityState) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.deviceGuardVirtualizationBasedSecurityState = deviceGuardVirtualizationBasedSecurityState;
        return _x;
    }

    /**
     * <i>“eSIM identifier”</i>
     * 
     * @return property esimIdentifier
     */
    @Property(name="esimIdentifier")
    @JsonIgnore
    public Optional<String> getEsimIdentifier() {
        return Optional.ofNullable(esimIdentifier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code esimIdentifier}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“eSIM identifier”</i>
     * 
     * @param esimIdentifier
     *            new value of {@code esimIdentifier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code esimIdentifier} field changed
     */
    public HardwareInformation withEsimIdentifier(String esimIdentifier) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.esimIdentifier = esimIdentifier;
        return _x;
    }

    /**
     * <i>“Free storage space of the device.”</i>
     * 
     * @return property freeStorageSpace
     */
    @Property(name="freeStorageSpace")
    @JsonIgnore
    public Optional<Long> getFreeStorageSpace() {
        return Optional.ofNullable(freeStorageSpace);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code freeStorageSpace}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Free storage space of the device.”</i>
     * 
     * @param freeStorageSpace
     *            new value of {@code freeStorageSpace} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code freeStorageSpace} field changed
     */
    public HardwareInformation withFreeStorageSpace(Long freeStorageSpace) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.freeStorageSpace = freeStorageSpace;
        return _x;
    }

    /**
     * <i>“IMEI”</i>
     * 
     * @return property imei
     */
    @Property(name="imei")
    @JsonIgnore
    public Optional<String> getImei() {
        return Optional.ofNullable(imei);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code imei} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“IMEI”</i>
     * 
     * @param imei
     *            new value of {@code imei} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code imei} field changed
     */
    public HardwareInformation withImei(String imei) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.imei = imei;
        return _x;
    }

    /**
     * <i>“IPAddressV4”</i>
     * 
     * @return property ipAddressV4
     */
    @Property(name="ipAddressV4")
    @JsonIgnore
    public Optional<String> getIpAddressV4() {
        return Optional.ofNullable(ipAddressV4);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code ipAddressV4}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“IPAddressV4”</i>
     * 
     * @param ipAddressV4
     *            new value of {@code ipAddressV4} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code ipAddressV4} field changed
     */
    public HardwareInformation withIpAddressV4(String ipAddressV4) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.ipAddressV4 = ipAddressV4;
        return _x;
    }

    /**
     * <i>“Encryption status of the device”</i>
     * 
     * @return property isEncrypted
     */
    @Property(name="isEncrypted")
    @JsonIgnore
    public Optional<Boolean> getIsEncrypted() {
        return Optional.ofNullable(isEncrypted);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isEncrypted}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Encryption status of the device”</i>
     * 
     * @param isEncrypted
     *            new value of {@code isEncrypted} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isEncrypted} field changed
     */
    public HardwareInformation withIsEncrypted(Boolean isEncrypted) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.isEncrypted = isEncrypted;
        return _x;
    }

    /**
     * <i>“Shared iPad”</i>
     * 
     * @return property isSharedDevice
     */
    @Property(name="isSharedDevice")
    @JsonIgnore
    public Optional<Boolean> getIsSharedDevice() {
        return Optional.ofNullable(isSharedDevice);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isSharedDevice}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Shared iPad”</i>
     * 
     * @param isSharedDevice
     *            new value of {@code isSharedDevice} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isSharedDevice} field changed
     */
    public HardwareInformation withIsSharedDevice(Boolean isSharedDevice) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.isSharedDevice = isSharedDevice;
        return _x;
    }

    /**
     * <i>“Supervised mode of the device”</i>
     * 
     * @return property isSupervised
     */
    @Property(name="isSupervised")
    @JsonIgnore
    public Optional<Boolean> getIsSupervised() {
        return Optional.ofNullable(isSupervised);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isSupervised}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Supervised mode of the device”</i>
     * 
     * @param isSupervised
     *            new value of {@code isSupervised} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isSupervised} field changed
     */
    public HardwareInformation withIsSupervised(Boolean isSupervised) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.isSupervised = isSupervised;
        return _x;
    }

    /**
     * <i>“Manufacturer of the device”</i>
     * 
     * @return property manufacturer
     */
    @Property(name="manufacturer")
    @JsonIgnore
    public Optional<String> getManufacturer() {
        return Optional.ofNullable(manufacturer);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code manufacturer}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Manufacturer of the device”</i>
     * 
     * @param manufacturer
     *            new value of {@code manufacturer} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code manufacturer} field changed
     */
    public HardwareInformation withManufacturer(String manufacturer) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.manufacturer = manufacturer;
        return _x;
    }

    /**
     * <i>“MEID”</i>
     * 
     * @return property meid
     */
    @Property(name="meid")
    @JsonIgnore
    public Optional<String> getMeid() {
        return Optional.ofNullable(meid);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code meid} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“MEID”</i>
     * 
     * @param meid
     *            new value of {@code meid} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code meid} field changed
     */
    public HardwareInformation withMeid(String meid) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.meid = meid;
        return _x;
    }

    /**
     * <i>“Model of the device”</i>
     * 
     * @return property model
     */
    @Property(name="model")
    @JsonIgnore
    public Optional<String> getModel() {
        return Optional.ofNullable(model);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code model} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Model of the device”</i>
     * 
     * @param model
     *            new value of {@code model} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code model} field changed
     */
    public HardwareInformation withModel(String model) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.model = model;
        return _x;
    }

    /**
     * <i>“String that specifies the OS edition.”</i>
     * 
     * @return property operatingSystemEdition
     */
    @Property(name="operatingSystemEdition")
    @JsonIgnore
    public Optional<String> getOperatingSystemEdition() {
        return Optional.ofNullable(operatingSystemEdition);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * operatingSystemEdition} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“String that specifies the OS edition.”</i>
     * 
     * @param operatingSystemEdition
     *            new value of {@code operatingSystemEdition} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code operatingSystemEdition} field changed
     */
    public HardwareInformation withOperatingSystemEdition(String operatingSystemEdition) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.operatingSystemEdition = operatingSystemEdition;
        return _x;
    }

    /**
     * <i>“Operating system language of the device”</i>
     * 
     * @return property operatingSystemLanguage
     */
    @Property(name="operatingSystemLanguage")
    @JsonIgnore
    public Optional<String> getOperatingSystemLanguage() {
        return Optional.ofNullable(operatingSystemLanguage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * operatingSystemLanguage} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Operating system language of the device”</i>
     * 
     * @param operatingSystemLanguage
     *            new value of {@code operatingSystemLanguage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code operatingSystemLanguage} field changed
     */
    public HardwareInformation withOperatingSystemLanguage(String operatingSystemLanguage) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.operatingSystemLanguage = operatingSystemLanguage;
        return _x;
    }

    /**
     * <i>“Int that specifies the Windows Operating System ProductType. More details here
     * https://go.microsoft.com/fwlink/?linkid=2126950. Valid values 0 to 2147483647”</i>
     * 
     * @return property operatingSystemProductType
     */
    @Property(name="operatingSystemProductType")
    @JsonIgnore
    public Optional<Integer> getOperatingSystemProductType() {
        return Optional.ofNullable(operatingSystemProductType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * operatingSystemProductType} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Int that specifies the Windows Operating System ProductType. More details here
     * https://go.microsoft.com/fwlink/?linkid=2126950. Valid values 0 to 2147483647”</i>
     * 
     * @param operatingSystemProductType
     *            new value of {@code operatingSystemProductType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code operatingSystemProductType} field changed
     */
    public HardwareInformation withOperatingSystemProductType(Integer operatingSystemProductType) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.operatingSystemProductType = operatingSystemProductType;
        return _x;
    }

    /**
     * <i>“Operating System Build Number on Android device”</i>
     * 
     * @return property osBuildNumber
     */
    @Property(name="osBuildNumber")
    @JsonIgnore
    public Optional<String> getOsBuildNumber() {
        return Optional.ofNullable(osBuildNumber);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code osBuildNumber}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Operating System Build Number on Android device”</i>
     * 
     * @param osBuildNumber
     *            new value of {@code osBuildNumber} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code osBuildNumber} field changed
     */
    public HardwareInformation withOsBuildNumber(String osBuildNumber) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.osBuildNumber = osBuildNumber;
        return _x;
    }

    /**
     * <i>“Phone number of the device”</i>
     * 
     * @return property phoneNumber
     */
    @Property(name="phoneNumber")
    @JsonIgnore
    public Optional<String> getPhoneNumber() {
        return Optional.ofNullable(phoneNumber);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code phoneNumber}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Phone number of the device”</i>
     * 
     * @param phoneNumber
     *            new value of {@code phoneNumber} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code phoneNumber} field changed
     */
    public HardwareInformation withPhoneNumber(String phoneNumber) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.phoneNumber = phoneNumber;
        return _x;
    }

    /**
     * <i>“Serial number.”</i>
     * 
     * @return property serialNumber
     */
    @Property(name="serialNumber")
    @JsonIgnore
    public Optional<String> getSerialNumber() {
        return Optional.ofNullable(serialNumber);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code serialNumber}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Serial number.”</i>
     * 
     * @param serialNumber
     *            new value of {@code serialNumber} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code serialNumber} field changed
     */
    public HardwareInformation withSerialNumber(String serialNumber) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.serialNumber = serialNumber;
        return _x;
    }

    /**
     * <i>“All users on the shared Apple device”</i>
     * 
     * @return property sharedDeviceCachedUsers
     */
    @Property(name="sharedDeviceCachedUsers")
    @JsonIgnore
    public CollectionPage<SharedAppleDeviceUser> getSharedDeviceCachedUsers() {
        return new CollectionPage<SharedAppleDeviceUser>(contextPath, SharedAppleDeviceUser.class, this.sharedDeviceCachedUsers, Optional.ofNullable(sharedDeviceCachedUsersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“All users on the shared Apple device”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property sharedDeviceCachedUsers
     */
    @Property(name="sharedDeviceCachedUsers")
    @JsonIgnore
    public CollectionPage<SharedAppleDeviceUser> getSharedDeviceCachedUsers(HttpRequestOptions options) {
        return new CollectionPage<SharedAppleDeviceUser>(contextPath, SharedAppleDeviceUser.class, this.sharedDeviceCachedUsers, Optional.ofNullable(sharedDeviceCachedUsersNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“SubnetAddress”</i>
     * 
     * @return property subnetAddress
     */
    @Property(name="subnetAddress")
    @JsonIgnore
    public Optional<String> getSubnetAddress() {
        return Optional.ofNullable(subnetAddress);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code subnetAddress}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“SubnetAddress”</i>
     * 
     * @param subnetAddress
     *            new value of {@code subnetAddress} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code subnetAddress} field changed
     */
    public HardwareInformation withSubnetAddress(String subnetAddress) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.subnetAddress = subnetAddress;
        return _x;
    }

    /**
     * <i>“Subscriber carrier of the device”</i>
     * 
     * @return property subscriberCarrier
     */
    @Property(name="subscriberCarrier")
    @JsonIgnore
    public Optional<String> getSubscriberCarrier() {
        return Optional.ofNullable(subscriberCarrier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code subscriberCarrier
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Subscriber carrier of the device”</i>
     * 
     * @param subscriberCarrier
     *            new value of {@code subscriberCarrier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code subscriberCarrier} field changed
     */
    public HardwareInformation withSubscriberCarrier(String subscriberCarrier) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.subscriberCarrier = subscriberCarrier;
        return _x;
    }

    /**
     * <i>“BIOS version as reported by SMBIOS”</i>
     * 
     * @return property systemManagementBIOSVersion
     */
    @Property(name="systemManagementBIOSVersion")
    @JsonIgnore
    public Optional<String> getSystemManagementBIOSVersion() {
        return Optional.ofNullable(systemManagementBIOSVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * systemManagementBIOSVersion} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“BIOS version as reported by SMBIOS”</i>
     * 
     * @param systemManagementBIOSVersion
     *            new value of {@code systemManagementBIOSVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code systemManagementBIOSVersion} field changed
     */
    public HardwareInformation withSystemManagementBIOSVersion(String systemManagementBIOSVersion) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.systemManagementBIOSVersion = systemManagementBIOSVersion;
        return _x;
    }

    /**
     * <i>“Total storage space of the device.”</i>
     * 
     * @return property totalStorageSpace
     */
    @Property(name="totalStorageSpace")
    @JsonIgnore
    public Optional<Long> getTotalStorageSpace() {
        return Optional.ofNullable(totalStorageSpace);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code totalStorageSpace
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Total storage space of the device.”</i>
     * 
     * @param totalStorageSpace
     *            new value of {@code totalStorageSpace} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code totalStorageSpace} field changed
     */
    public HardwareInformation withTotalStorageSpace(Long totalStorageSpace) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.totalStorageSpace = totalStorageSpace;
        return _x;
    }

    /**
     * <i>“The identifying information that uniquely names the TPM manufacturer”</i>
     * 
     * @return property tpmManufacturer
     */
    @Property(name="tpmManufacturer")
    @JsonIgnore
    public Optional<String> getTpmManufacturer() {
        return Optional.ofNullable(tpmManufacturer);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code tpmManufacturer}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The identifying information that uniquely names the TPM manufacturer”</i>
     * 
     * @param tpmManufacturer
     *            new value of {@code tpmManufacturer} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code tpmManufacturer} field changed
     */
    public HardwareInformation withTpmManufacturer(String tpmManufacturer) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.tpmManufacturer = tpmManufacturer;
        return _x;
    }

    /**
     * <i>“String that specifies the specification version.”</i>
     * 
     * @return property tpmSpecificationVersion
     */
    @Property(name="tpmSpecificationVersion")
    @JsonIgnore
    public Optional<String> getTpmSpecificationVersion() {
        return Optional.ofNullable(tpmSpecificationVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * tpmSpecificationVersion} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“String that specifies the specification version.”</i>
     * 
     * @param tpmSpecificationVersion
     *            new value of {@code tpmSpecificationVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code tpmSpecificationVersion} field changed
     */
    public HardwareInformation withTpmSpecificationVersion(String tpmSpecificationVersion) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.tpmSpecificationVersion = tpmSpecificationVersion;
        return _x;
    }

    /**
     * <i>“The version of the TPM, as specified by the manufacturer”</i>
     * 
     * @return property tpmVersion
     */
    @Property(name="tpmVersion")
    @JsonIgnore
    public Optional<String> getTpmVersion() {
        return Optional.ofNullable(tpmVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code tpmVersion} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The version of the TPM, as specified by the manufacturer”</i>
     * 
     * @param tpmVersion
     *            new value of {@code tpmVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code tpmVersion} field changed
     */
    public HardwareInformation withTpmVersion(String tpmVersion) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.tpmVersion = tpmVersion;
        return _x;
    }

    /**
     * <i>“WiFi MAC address of the device”</i>
     * 
     * @return property wifiMac
     */
    @Property(name="wifiMac")
    @JsonIgnore
    public Optional<String> getWifiMac() {
        return Optional.ofNullable(wifiMac);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code wifiMac} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“WiFi MAC address of the device”</i>
     * 
     * @param wifiMac
     *            new value of {@code wifiMac} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code wifiMac} field changed
     */
    public HardwareInformation withWifiMac(String wifiMac) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.wifiMac = wifiMac;
        return _x;
    }

    public HardwareInformation withUnmappedField(String name, Object value) {
        HardwareInformation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer batteryChargeCycles;
        private Integer batteryHealthPercentage;
        private String batterySerialNumber;
        private String cellularTechnology;
        private String deviceFullQualifiedDomainName;
        private DeviceGuardLocalSystemAuthorityCredentialGuardState deviceGuardLocalSystemAuthorityCredentialGuardState;
        private DeviceGuardVirtualizationBasedSecurityHardwareRequirementState deviceGuardVirtualizationBasedSecurityHardwareRequirementState;
        private DeviceGuardVirtualizationBasedSecurityState deviceGuardVirtualizationBasedSecurityState;
        private String esimIdentifier;
        private Long freeStorageSpace;
        private String imei;
        private String ipAddressV4;
        private Boolean isEncrypted;
        private Boolean isSharedDevice;
        private Boolean isSupervised;
        private String manufacturer;
        private String meid;
        private String model;
        private String operatingSystemEdition;
        private String operatingSystemLanguage;
        private Integer operatingSystemProductType;
        private String osBuildNumber;
        private String phoneNumber;
        private String serialNumber;
        private List<SharedAppleDeviceUser> sharedDeviceCachedUsers;
        private String sharedDeviceCachedUsersNextLink;
        private String subnetAddress;
        private String subscriberCarrier;
        private String systemManagementBIOSVersion;
        private Long totalStorageSpace;
        private String tpmManufacturer;
        private String tpmSpecificationVersion;
        private String tpmVersion;
        private String wifiMac;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The number of charge cycles the device’s current battery has gone through. Valid
         * values 0 to 2147483647”</i>
         * 
         * @param batteryChargeCycles
         *            value of {@code batteryChargeCycles} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder batteryChargeCycles(Integer batteryChargeCycles) {
            this.batteryChargeCycles = batteryChargeCycles;
            this.changedFields = changedFields.add("batteryChargeCycles");
            return this;
        }

        /**
         * <i>“The device’s current battery’s health percentage. Valid values 0 to 100”</i>
         * 
         * @param batteryHealthPercentage
         *            value of {@code batteryHealthPercentage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder batteryHealthPercentage(Integer batteryHealthPercentage) {
            this.batteryHealthPercentage = batteryHealthPercentage;
            this.changedFields = changedFields.add("batteryHealthPercentage");
            return this;
        }

        /**
         * <i>“The serial number of the device’s current battery”</i>
         * 
         * @param batterySerialNumber
         *            value of {@code batterySerialNumber} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder batterySerialNumber(String batterySerialNumber) {
            this.batterySerialNumber = batterySerialNumber;
            this.changedFields = changedFields.add("batterySerialNumber");
            return this;
        }

        /**
         * <i>“Cellular technology of the device”</i>
         * 
         * @param cellularTechnology
         *            value of {@code cellularTechnology} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cellularTechnology(String cellularTechnology) {
            this.cellularTechnology = cellularTechnology;
            this.changedFields = changedFields.add("cellularTechnology");
            return this;
        }

        /**
         * <i>“Returns the fully qualified domain name of the device (if any). If the device is
         * not domain-joined, it returns an empty string.”</i>
         * 
         * @param deviceFullQualifiedDomainName
         *            value of {@code deviceFullQualifiedDomainName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceFullQualifiedDomainName(String deviceFullQualifiedDomainName) {
            this.deviceFullQualifiedDomainName = deviceFullQualifiedDomainName;
            this.changedFields = changedFields.add("deviceFullQualifiedDomainName");
            return this;
        }

        /**
         * <i>“Local System Authority (LSA) credential guard status.”</i>
         * 
         * @param deviceGuardLocalSystemAuthorityCredentialGuardState
         *            value of {@code deviceGuardLocalSystemAuthorityCredentialGuardState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceGuardLocalSystemAuthorityCredentialGuardState(DeviceGuardLocalSystemAuthorityCredentialGuardState deviceGuardLocalSystemAuthorityCredentialGuardState) {
            this.deviceGuardLocalSystemAuthorityCredentialGuardState = deviceGuardLocalSystemAuthorityCredentialGuardState;
            this.changedFields = changedFields.add("deviceGuardLocalSystemAuthorityCredentialGuardState");
            return this;
        }

        /**
         * <i>“Virtualization-based security hardware requirement status.”</i>
         * 
         * @param deviceGuardVirtualizationBasedSecurityHardwareRequirementState
         *            value of {@code deviceGuardVirtualizationBasedSecurityHardwareRequirementState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceGuardVirtualizationBasedSecurityHardwareRequirementState(DeviceGuardVirtualizationBasedSecurityHardwareRequirementState deviceGuardVirtualizationBasedSecurityHardwareRequirementState) {
            this.deviceGuardVirtualizationBasedSecurityHardwareRequirementState = deviceGuardVirtualizationBasedSecurityHardwareRequirementState;
            this.changedFields = changedFields.add("deviceGuardVirtualizationBasedSecurityHardwareRequirementState");
            return this;
        }

        /**
         * <i>“Virtualization-based security status.”</i>
         * 
         * @param deviceGuardVirtualizationBasedSecurityState
         *            value of {@code deviceGuardVirtualizationBasedSecurityState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceGuardVirtualizationBasedSecurityState(DeviceGuardVirtualizationBasedSecurityState deviceGuardVirtualizationBasedSecurityState) {
            this.deviceGuardVirtualizationBasedSecurityState = deviceGuardVirtualizationBasedSecurityState;
            this.changedFields = changedFields.add("deviceGuardVirtualizationBasedSecurityState");
            return this;
        }

        /**
         * <i>“eSIM identifier”</i>
         * 
         * @param esimIdentifier
         *            value of {@code esimIdentifier} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder esimIdentifier(String esimIdentifier) {
            this.esimIdentifier = esimIdentifier;
            this.changedFields = changedFields.add("esimIdentifier");
            return this;
        }

        /**
         * <i>“Free storage space of the device.”</i>
         * 
         * @param freeStorageSpace
         *            value of {@code freeStorageSpace} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder freeStorageSpace(Long freeStorageSpace) {
            this.freeStorageSpace = freeStorageSpace;
            this.changedFields = changedFields.add("freeStorageSpace");
            return this;
        }

        /**
         * <i>“IMEI”</i>
         * 
         * @param imei
         *            value of {@code imei} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder imei(String imei) {
            this.imei = imei;
            this.changedFields = changedFields.add("imei");
            return this;
        }

        /**
         * <i>“IPAddressV4”</i>
         * 
         * @param ipAddressV4
         *            value of {@code ipAddressV4} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ipAddressV4(String ipAddressV4) {
            this.ipAddressV4 = ipAddressV4;
            this.changedFields = changedFields.add("ipAddressV4");
            return this;
        }

        /**
         * <i>“Encryption status of the device”</i>
         * 
         * @param isEncrypted
         *            value of {@code isEncrypted} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isEncrypted(Boolean isEncrypted) {
            this.isEncrypted = isEncrypted;
            this.changedFields = changedFields.add("isEncrypted");
            return this;
        }

        /**
         * <i>“Shared iPad”</i>
         * 
         * @param isSharedDevice
         *            value of {@code isSharedDevice} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isSharedDevice(Boolean isSharedDevice) {
            this.isSharedDevice = isSharedDevice;
            this.changedFields = changedFields.add("isSharedDevice");
            return this;
        }

        /**
         * <i>“Supervised mode of the device”</i>
         * 
         * @param isSupervised
         *            value of {@code isSupervised} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isSupervised(Boolean isSupervised) {
            this.isSupervised = isSupervised;
            this.changedFields = changedFields.add("isSupervised");
            return this;
        }

        /**
         * <i>“Manufacturer of the device”</i>
         * 
         * @param manufacturer
         *            value of {@code manufacturer} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            this.changedFields = changedFields.add("manufacturer");
            return this;
        }

        /**
         * <i>“MEID”</i>
         * 
         * @param meid
         *            value of {@code meid} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder meid(String meid) {
            this.meid = meid;
            this.changedFields = changedFields.add("meid");
            return this;
        }

        /**
         * <i>“Model of the device”</i>
         * 
         * @param model
         *            value of {@code model} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder model(String model) {
            this.model = model;
            this.changedFields = changedFields.add("model");
            return this;
        }

        /**
         * <i>“String that specifies the OS edition.”</i>
         * 
         * @param operatingSystemEdition
         *            value of {@code operatingSystemEdition} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder operatingSystemEdition(String operatingSystemEdition) {
            this.operatingSystemEdition = operatingSystemEdition;
            this.changedFields = changedFields.add("operatingSystemEdition");
            return this;
        }

        /**
         * <i>“Operating system language of the device”</i>
         * 
         * @param operatingSystemLanguage
         *            value of {@code operatingSystemLanguage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder operatingSystemLanguage(String operatingSystemLanguage) {
            this.operatingSystemLanguage = operatingSystemLanguage;
            this.changedFields = changedFields.add("operatingSystemLanguage");
            return this;
        }

        /**
         * <i>“Int that specifies the Windows Operating System ProductType. More details here
         * https://go.microsoft.com/fwlink/?linkid=2126950. Valid values 0 to 2147483647”</i>
         * 
         * @param operatingSystemProductType
         *            value of {@code operatingSystemProductType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder operatingSystemProductType(Integer operatingSystemProductType) {
            this.operatingSystemProductType = operatingSystemProductType;
            this.changedFields = changedFields.add("operatingSystemProductType");
            return this;
        }

        /**
         * <i>“Operating System Build Number on Android device”</i>
         * 
         * @param osBuildNumber
         *            value of {@code osBuildNumber} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osBuildNumber(String osBuildNumber) {
            this.osBuildNumber = osBuildNumber;
            this.changedFields = changedFields.add("osBuildNumber");
            return this;
        }

        /**
         * <i>“Phone number of the device”</i>
         * 
         * @param phoneNumber
         *            value of {@code phoneNumber} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            this.changedFields = changedFields.add("phoneNumber");
            return this;
        }

        /**
         * <i>“Serial number.”</i>
         * 
         * @param serialNumber
         *            value of {@code serialNumber} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            this.changedFields = changedFields.add("serialNumber");
            return this;
        }

        /**
         * <i>“All users on the shared Apple device”</i>
         * 
         * @param sharedDeviceCachedUsers
         *            value of {@code sharedDeviceCachedUsers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder sharedDeviceCachedUsers(List<SharedAppleDeviceUser> sharedDeviceCachedUsers) {
            this.sharedDeviceCachedUsers = sharedDeviceCachedUsers;
            this.changedFields = changedFields.add("sharedDeviceCachedUsers");
            return this;
        }

        /**
         * <i>“All users on the shared Apple device”</i>
         * 
         * @param sharedDeviceCachedUsers
         *            value of {@code sharedDeviceCachedUsers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder sharedDeviceCachedUsers(SharedAppleDeviceUser... sharedDeviceCachedUsers) {
            return sharedDeviceCachedUsers(Arrays.asList(sharedDeviceCachedUsers));
        }

        /**
         * <i>“All users on the shared Apple device”</i>
         * 
         * @param sharedDeviceCachedUsersNextLink
         *            value of {@code sharedDeviceCachedUsers@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder sharedDeviceCachedUsersNextLink(String sharedDeviceCachedUsersNextLink) {
            this.sharedDeviceCachedUsersNextLink = sharedDeviceCachedUsersNextLink;
            this.changedFields = changedFields.add("sharedDeviceCachedUsers");
            return this;
        }

        /**
         * <i>“SubnetAddress”</i>
         * 
         * @param subnetAddress
         *            value of {@code subnetAddress} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder subnetAddress(String subnetAddress) {
            this.subnetAddress = subnetAddress;
            this.changedFields = changedFields.add("subnetAddress");
            return this;
        }

        /**
         * <i>“Subscriber carrier of the device”</i>
         * 
         * @param subscriberCarrier
         *            value of {@code subscriberCarrier} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder subscriberCarrier(String subscriberCarrier) {
            this.subscriberCarrier = subscriberCarrier;
            this.changedFields = changedFields.add("subscriberCarrier");
            return this;
        }

        /**
         * <i>“BIOS version as reported by SMBIOS”</i>
         * 
         * @param systemManagementBIOSVersion
         *            value of {@code systemManagementBIOSVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder systemManagementBIOSVersion(String systemManagementBIOSVersion) {
            this.systemManagementBIOSVersion = systemManagementBIOSVersion;
            this.changedFields = changedFields.add("systemManagementBIOSVersion");
            return this;
        }

        /**
         * <i>“Total storage space of the device.”</i>
         * 
         * @param totalStorageSpace
         *            value of {@code totalStorageSpace} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder totalStorageSpace(Long totalStorageSpace) {
            this.totalStorageSpace = totalStorageSpace;
            this.changedFields = changedFields.add("totalStorageSpace");
            return this;
        }

        /**
         * <i>“The identifying information that uniquely names the TPM manufacturer”</i>
         * 
         * @param tpmManufacturer
         *            value of {@code tpmManufacturer} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder tpmManufacturer(String tpmManufacturer) {
            this.tpmManufacturer = tpmManufacturer;
            this.changedFields = changedFields.add("tpmManufacturer");
            return this;
        }

        /**
         * <i>“String that specifies the specification version.”</i>
         * 
         * @param tpmSpecificationVersion
         *            value of {@code tpmSpecificationVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder tpmSpecificationVersion(String tpmSpecificationVersion) {
            this.tpmSpecificationVersion = tpmSpecificationVersion;
            this.changedFields = changedFields.add("tpmSpecificationVersion");
            return this;
        }

        /**
         * <i>“The version of the TPM, as specified by the manufacturer”</i>
         * 
         * @param tpmVersion
         *            value of {@code tpmVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder tpmVersion(String tpmVersion) {
            this.tpmVersion = tpmVersion;
            this.changedFields = changedFields.add("tpmVersion");
            return this;
        }

        /**
         * <i>“WiFi MAC address of the device”</i>
         * 
         * @param wifiMac
         *            value of {@code wifiMac} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder wifiMac(String wifiMac) {
            this.wifiMac = wifiMac;
            this.changedFields = changedFields.add("wifiMac");
            return this;
        }

        public HardwareInformation build() {
            HardwareInformation _x = new HardwareInformation();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.hardwareInformation";
            _x.batteryChargeCycles = batteryChargeCycles;
            _x.batteryHealthPercentage = batteryHealthPercentage;
            _x.batterySerialNumber = batterySerialNumber;
            _x.cellularTechnology = cellularTechnology;
            _x.deviceFullQualifiedDomainName = deviceFullQualifiedDomainName;
            _x.deviceGuardLocalSystemAuthorityCredentialGuardState = deviceGuardLocalSystemAuthorityCredentialGuardState;
            _x.deviceGuardVirtualizationBasedSecurityHardwareRequirementState = deviceGuardVirtualizationBasedSecurityHardwareRequirementState;
            _x.deviceGuardVirtualizationBasedSecurityState = deviceGuardVirtualizationBasedSecurityState;
            _x.esimIdentifier = esimIdentifier;
            _x.freeStorageSpace = freeStorageSpace;
            _x.imei = imei;
            _x.ipAddressV4 = ipAddressV4;
            _x.isEncrypted = isEncrypted;
            _x.isSharedDevice = isSharedDevice;
            _x.isSupervised = isSupervised;
            _x.manufacturer = manufacturer;
            _x.meid = meid;
            _x.model = model;
            _x.operatingSystemEdition = operatingSystemEdition;
            _x.operatingSystemLanguage = operatingSystemLanguage;
            _x.operatingSystemProductType = operatingSystemProductType;
            _x.osBuildNumber = osBuildNumber;
            _x.phoneNumber = phoneNumber;
            _x.serialNumber = serialNumber;
            _x.sharedDeviceCachedUsers = sharedDeviceCachedUsers;
            _x.sharedDeviceCachedUsersNextLink = sharedDeviceCachedUsersNextLink;
            _x.subnetAddress = subnetAddress;
            _x.subscriberCarrier = subscriberCarrier;
            _x.systemManagementBIOSVersion = systemManagementBIOSVersion;
            _x.totalStorageSpace = totalStorageSpace;
            _x.tpmManufacturer = tpmManufacturer;
            _x.tpmSpecificationVersion = tpmSpecificationVersion;
            _x.tpmVersion = tpmVersion;
            _x.wifiMac = wifiMac;
            return _x;
        }
    }

    private HardwareInformation _copy() {
        HardwareInformation _x = new HardwareInformation();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.batteryChargeCycles = batteryChargeCycles;
        _x.batteryHealthPercentage = batteryHealthPercentage;
        _x.batterySerialNumber = batterySerialNumber;
        _x.cellularTechnology = cellularTechnology;
        _x.deviceFullQualifiedDomainName = deviceFullQualifiedDomainName;
        _x.deviceGuardLocalSystemAuthorityCredentialGuardState = deviceGuardLocalSystemAuthorityCredentialGuardState;
        _x.deviceGuardVirtualizationBasedSecurityHardwareRequirementState = deviceGuardVirtualizationBasedSecurityHardwareRequirementState;
        _x.deviceGuardVirtualizationBasedSecurityState = deviceGuardVirtualizationBasedSecurityState;
        _x.esimIdentifier = esimIdentifier;
        _x.freeStorageSpace = freeStorageSpace;
        _x.imei = imei;
        _x.ipAddressV4 = ipAddressV4;
        _x.isEncrypted = isEncrypted;
        _x.isSharedDevice = isSharedDevice;
        _x.isSupervised = isSupervised;
        _x.manufacturer = manufacturer;
        _x.meid = meid;
        _x.model = model;
        _x.operatingSystemEdition = operatingSystemEdition;
        _x.operatingSystemLanguage = operatingSystemLanguage;
        _x.operatingSystemProductType = operatingSystemProductType;
        _x.osBuildNumber = osBuildNumber;
        _x.phoneNumber = phoneNumber;
        _x.serialNumber = serialNumber;
        _x.sharedDeviceCachedUsers = sharedDeviceCachedUsers;
        _x.subnetAddress = subnetAddress;
        _x.subscriberCarrier = subscriberCarrier;
        _x.systemManagementBIOSVersion = systemManagementBIOSVersion;
        _x.totalStorageSpace = totalStorageSpace;
        _x.tpmManufacturer = tpmManufacturer;
        _x.tpmSpecificationVersion = tpmSpecificationVersion;
        _x.tpmVersion = tpmVersion;
        _x.wifiMac = wifiMac;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("HardwareInformation[");
        b.append("batteryChargeCycles=");
        b.append(this.batteryChargeCycles);
        b.append(", ");
        b.append("batteryHealthPercentage=");
        b.append(this.batteryHealthPercentage);
        b.append(", ");
        b.append("batterySerialNumber=");
        b.append(this.batterySerialNumber);
        b.append(", ");
        b.append("cellularTechnology=");
        b.append(this.cellularTechnology);
        b.append(", ");
        b.append("deviceFullQualifiedDomainName=");
        b.append(this.deviceFullQualifiedDomainName);
        b.append(", ");
        b.append("deviceGuardLocalSystemAuthorityCredentialGuardState=");
        b.append(this.deviceGuardLocalSystemAuthorityCredentialGuardState);
        b.append(", ");
        b.append("deviceGuardVirtualizationBasedSecurityHardwareRequirementState=");
        b.append(this.deviceGuardVirtualizationBasedSecurityHardwareRequirementState);
        b.append(", ");
        b.append("deviceGuardVirtualizationBasedSecurityState=");
        b.append(this.deviceGuardVirtualizationBasedSecurityState);
        b.append(", ");
        b.append("esimIdentifier=");
        b.append(this.esimIdentifier);
        b.append(", ");
        b.append("freeStorageSpace=");
        b.append(this.freeStorageSpace);
        b.append(", ");
        b.append("imei=");
        b.append(this.imei);
        b.append(", ");
        b.append("ipAddressV4=");
        b.append(this.ipAddressV4);
        b.append(", ");
        b.append("isEncrypted=");
        b.append(this.isEncrypted);
        b.append(", ");
        b.append("isSharedDevice=");
        b.append(this.isSharedDevice);
        b.append(", ");
        b.append("isSupervised=");
        b.append(this.isSupervised);
        b.append(", ");
        b.append("manufacturer=");
        b.append(this.manufacturer);
        b.append(", ");
        b.append("meid=");
        b.append(this.meid);
        b.append(", ");
        b.append("model=");
        b.append(this.model);
        b.append(", ");
        b.append("operatingSystemEdition=");
        b.append(this.operatingSystemEdition);
        b.append(", ");
        b.append("operatingSystemLanguage=");
        b.append(this.operatingSystemLanguage);
        b.append(", ");
        b.append("operatingSystemProductType=");
        b.append(this.operatingSystemProductType);
        b.append(", ");
        b.append("osBuildNumber=");
        b.append(this.osBuildNumber);
        b.append(", ");
        b.append("phoneNumber=");
        b.append(this.phoneNumber);
        b.append(", ");
        b.append("serialNumber=");
        b.append(this.serialNumber);
        b.append(", ");
        b.append("sharedDeviceCachedUsers=");
        b.append(this.sharedDeviceCachedUsers);
        b.append(", ");
        b.append("subnetAddress=");
        b.append(this.subnetAddress);
        b.append(", ");
        b.append("subscriberCarrier=");
        b.append(this.subscriberCarrier);
        b.append(", ");
        b.append("systemManagementBIOSVersion=");
        b.append(this.systemManagementBIOSVersion);
        b.append(", ");
        b.append("totalStorageSpace=");
        b.append(this.totalStorageSpace);
        b.append(", ");
        b.append("tpmManufacturer=");
        b.append(this.tpmManufacturer);
        b.append(", ");
        b.append("tpmSpecificationVersion=");
        b.append(this.tpmSpecificationVersion);
        b.append(", ");
        b.append("tpmVersion=");
        b.append(this.tpmVersion);
        b.append(", ");
        b.append("wifiMac=");
        b.append(this.wifiMac);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
