package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "culture", 
    "id", 
    "source", 
    "type", 
    "version"})
@JsonInclude(Include.NON_NULL)
public class GovernanceNotificationTemplate implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("culture")
    protected String culture;

    @JsonProperty("id")
    protected String id;

    @JsonProperty("source")
    protected String source;

    @JsonProperty("type")
    protected String type;

    @JsonProperty("version")
    protected String version;

    protected GovernanceNotificationTemplate() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.governanceNotificationTemplate";
    }

    @Property(name="culture")
    @JsonIgnore
    public Optional<String> getCulture() {
        return Optional.ofNullable(culture);
    }

    public GovernanceNotificationTemplate withCulture(String culture) {
        GovernanceNotificationTemplate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceNotificationTemplate");
        _x.culture = culture;
        return _x;
    }

    @Property(name="id")
    @JsonIgnore
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    public GovernanceNotificationTemplate withId(String id) {
        GovernanceNotificationTemplate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceNotificationTemplate");
        _x.id = id;
        return _x;
    }

    @Property(name="source")
    @JsonIgnore
    public Optional<String> getSource() {
        return Optional.ofNullable(source);
    }

    public GovernanceNotificationTemplate withSource(String source) {
        GovernanceNotificationTemplate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceNotificationTemplate");
        _x.source = source;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<String> getType() {
        return Optional.ofNullable(type);
    }

    public GovernanceNotificationTemplate withType(String type) {
        GovernanceNotificationTemplate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceNotificationTemplate");
        _x.type = type;
        return _x;
    }

    @Property(name="version")
    @JsonIgnore
    public Optional<String> getVersion() {
        return Optional.ofNullable(version);
    }

    public GovernanceNotificationTemplate withVersion(String version) {
        GovernanceNotificationTemplate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceNotificationTemplate");
        _x.version = version;
        return _x;
    }

    public GovernanceNotificationTemplate withUnmappedField(String name, Object value) {
        GovernanceNotificationTemplate _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String culture;
        private String id;
        private String source;
        private String type;
        private String version;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder culture(String culture) {
            this.culture = culture;
            this.changedFields = changedFields.add("culture");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder source(String source) {
            this.source = source;
            this.changedFields = changedFields.add("source");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public GovernanceNotificationTemplate build() {
            GovernanceNotificationTemplate _x = new GovernanceNotificationTemplate();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.governanceNotificationTemplate";
            _x.culture = culture;
            _x.id = id;
            _x.source = source;
            _x.type = type;
            _x.version = version;
            return _x;
        }
    }

    private GovernanceNotificationTemplate _copy() {
        GovernanceNotificationTemplate _x = new GovernanceNotificationTemplate();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.culture = culture;
        _x.id = id;
        _x.source = source;
        _x.type = type;
        _x.version = version;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GovernanceNotificationTemplate[");
        b.append("culture=");
        b.append(this.culture);
        b.append(", ");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("source=");
        b.append(this.source);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
