package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "message", 
    "responseCode"})
@JsonInclude(Include.NON_NULL)
public class FreeBusyError implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("message")
    protected String message;

    @JsonProperty("responseCode")
    protected String responseCode;

    protected FreeBusyError() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.freeBusyError";
    }

    @Property(name="message")
    @JsonIgnore
    public Optional<String> getMessage() {
        return Optional.ofNullable(message);
    }

    public FreeBusyError withMessage(String message) {
        FreeBusyError _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.freeBusyError");
        _x.message = message;
        return _x;
    }

    @Property(name="responseCode")
    @JsonIgnore
    public Optional<String> getResponseCode() {
        return Optional.ofNullable(responseCode);
    }

    public FreeBusyError withResponseCode(String responseCode) {
        FreeBusyError _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.freeBusyError");
        _x.responseCode = responseCode;
        return _x;
    }

    public FreeBusyError withUnmappedField(String name, Object value) {
        FreeBusyError _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String message;
        private String responseCode;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder message(String message) {
            this.message = message;
            this.changedFields = changedFields.add("message");
            return this;
        }

        public Builder responseCode(String responseCode) {
            this.responseCode = responseCode;
            this.changedFields = changedFields.add("responseCode");
            return this;
        }

        public FreeBusyError build() {
            FreeBusyError _x = new FreeBusyError();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.freeBusyError";
            _x.message = message;
            _x.responseCode = responseCode;
            return _x;
        }
    }

    private FreeBusyError _copy() {
        FreeBusyError _x = new FreeBusyError();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.message = message;
        _x.responseCode = responseCode;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("FreeBusyError[");
        b.append("message=");
        b.append(this.message);
        b.append(", ");
        b.append("responseCode=");
        b.append(this.responseCode);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
