package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.FollowupFlagStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "completedDateTime", 
    "dueDateTime", 
    "flagStatus", 
    "startDateTime"})
@JsonInclude(Include.NON_NULL)
public class FollowupFlag implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("completedDateTime")
    protected DateTimeTimeZone completedDateTime;

    @JsonProperty("dueDateTime")
    protected DateTimeTimeZone dueDateTime;

    @JsonProperty("flagStatus")
    protected FollowupFlagStatus flagStatus;

    @JsonProperty("startDateTime")
    protected DateTimeTimeZone startDateTime;

    protected FollowupFlag() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.followupFlag";
    }

    @Property(name="completedDateTime")
    @JsonIgnore
    public Optional<DateTimeTimeZone> getCompletedDateTime() {
        return Optional.ofNullable(completedDateTime);
    }

    public FollowupFlag withCompletedDateTime(DateTimeTimeZone completedDateTime) {
        FollowupFlag _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.followupFlag");
        _x.completedDateTime = completedDateTime;
        return _x;
    }

    @Property(name="dueDateTime")
    @JsonIgnore
    public Optional<DateTimeTimeZone> getDueDateTime() {
        return Optional.ofNullable(dueDateTime);
    }

    public FollowupFlag withDueDateTime(DateTimeTimeZone dueDateTime) {
        FollowupFlag _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.followupFlag");
        _x.dueDateTime = dueDateTime;
        return _x;
    }

    @Property(name="flagStatus")
    @JsonIgnore
    public Optional<FollowupFlagStatus> getFlagStatus() {
        return Optional.ofNullable(flagStatus);
    }

    public FollowupFlag withFlagStatus(FollowupFlagStatus flagStatus) {
        FollowupFlag _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.followupFlag");
        _x.flagStatus = flagStatus;
        return _x;
    }

    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<DateTimeTimeZone> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    public FollowupFlag withStartDateTime(DateTimeTimeZone startDateTime) {
        FollowupFlag _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.followupFlag");
        _x.startDateTime = startDateTime;
        return _x;
    }

    public FollowupFlag withUnmappedField(String name, Object value) {
        FollowupFlag _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private DateTimeTimeZone completedDateTime;
        private DateTimeTimeZone dueDateTime;
        private FollowupFlagStatus flagStatus;
        private DateTimeTimeZone startDateTime;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder completedDateTime(DateTimeTimeZone completedDateTime) {
            this.completedDateTime = completedDateTime;
            this.changedFields = changedFields.add("completedDateTime");
            return this;
        }

        public Builder dueDateTime(DateTimeTimeZone dueDateTime) {
            this.dueDateTime = dueDateTime;
            this.changedFields = changedFields.add("dueDateTime");
            return this;
        }

        public Builder flagStatus(FollowupFlagStatus flagStatus) {
            this.flagStatus = flagStatus;
            this.changedFields = changedFields.add("flagStatus");
            return this;
        }

        public Builder startDateTime(DateTimeTimeZone startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public FollowupFlag build() {
            FollowupFlag _x = new FollowupFlag();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.followupFlag";
            _x.completedDateTime = completedDateTime;
            _x.dueDateTime = dueDateTime;
            _x.flagStatus = flagStatus;
            _x.startDateTime = startDateTime;
            return _x;
        }
    }

    private FollowupFlag _copy() {
        FollowupFlag _x = new FollowupFlag();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.completedDateTime = completedDateTime;
        _x.dueDateTime = dueDateTime;
        _x.flagStatus = flagStatus;
        _x.startDateTime = startDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("FollowupFlag[");
        b.append("completedDateTime=");
        b.append(this.completedDateTime);
        b.append(", ");
        b.append("dueDateTime=");
        b.append(this.dueDateTime);
        b.append(", ");
        b.append("flagStatus=");
        b.append(this.flagStatus);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
