package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "sortBy", 
    "sortOrder", 
    "viewType"})
@JsonInclude(Include.NON_NULL)
public class FolderView implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("sortBy")
    protected String sortBy;

    @JsonProperty("sortOrder")
    protected String sortOrder;

    @JsonProperty("viewType")
    protected String viewType;

    protected FolderView() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.folderView";
    }

    @Property(name="sortBy")
    @JsonIgnore
    public Optional<String> getSortBy() {
        return Optional.ofNullable(sortBy);
    }

    public FolderView withSortBy(String sortBy) {
        FolderView _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.folderView");
        _x.sortBy = sortBy;
        return _x;
    }

    @Property(name="sortOrder")
    @JsonIgnore
    public Optional<String> getSortOrder() {
        return Optional.ofNullable(sortOrder);
    }

    public FolderView withSortOrder(String sortOrder) {
        FolderView _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.folderView");
        _x.sortOrder = sortOrder;
        return _x;
    }

    @Property(name="viewType")
    @JsonIgnore
    public Optional<String> getViewType() {
        return Optional.ofNullable(viewType);
    }

    public FolderView withViewType(String viewType) {
        FolderView _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.folderView");
        _x.viewType = viewType;
        return _x;
    }

    public FolderView withUnmappedField(String name, Object value) {
        FolderView _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String sortBy;
        private String sortOrder;
        private String viewType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            this.changedFields = changedFields.add("sortBy");
            return this;
        }

        public Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            this.changedFields = changedFields.add("sortOrder");
            return this;
        }

        public Builder viewType(String viewType) {
            this.viewType = viewType;
            this.changedFields = changedFields.add("viewType");
            return this;
        }

        public FolderView build() {
            FolderView _x = new FolderView();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.folderView";
            _x.sortBy = sortBy;
            _x.sortOrder = sortOrder;
            _x.viewType = viewType;
            return _x;
        }
    }

    private FolderView _copy() {
        FolderView _x = new FolderView();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.sortBy = sortBy;
        _x.sortOrder = sortOrder;
        _x.viewType = viewType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("FolderView[");
        b.append("sortBy=");
        b.append(this.sortBy);
        b.append(", ");
        b.append("sortOrder=");
        b.append(this.sortOrder);
        b.append(", ");
        b.append("viewType=");
        b.append(this.viewType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
