package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "childCount", 
    "view"})
@JsonInclude(Include.NON_NULL)
public class Folder implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("childCount")
    protected Integer childCount;

    @JsonProperty("view")
    protected FolderView view;

    protected Folder() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.folder";
    }

    @Property(name="childCount")
    @JsonIgnore
    public Optional<Integer> getChildCount() {
        return Optional.ofNullable(childCount);
    }

    public Folder withChildCount(Integer childCount) {
        Folder _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.folder");
        _x.childCount = childCount;
        return _x;
    }

    @Property(name="view")
    @JsonIgnore
    public Optional<FolderView> getView() {
        return Optional.ofNullable(view);
    }

    public Folder withView(FolderView view) {
        Folder _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.folder");
        _x.view = view;
        return _x;
    }

    public Folder withUnmappedField(String name, Object value) {
        Folder _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer childCount;
        private FolderView view;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder childCount(Integer childCount) {
            this.childCount = childCount;
            this.changedFields = changedFields.add("childCount");
            return this;
        }

        public Builder view(FolderView view) {
            this.view = view;
            this.changedFields = changedFields.add("view");
            return this;
        }

        public Folder build() {
            Folder _x = new Folder();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.folder";
            _x.childCount = childCount;
            _x.view = view;
            return _x;
        }
    }

    private Folder _copy() {
        Folder _x = new Folder();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.childCount = childCount;
        _x.view = view;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Folder[");
        b.append("childCount=");
        b.append(this.childCount);
        b.append(", ");
        b.append("view=");
        b.append(this.view);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
