package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Contains properties for file encryption information for the content version of a
 * line of business app.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "encryptionKey", 
    "fileDigest", 
    "fileDigestAlgorithm", 
    "initializationVector", 
    "mac", 
    "macKey", 
    "profileIdentifier"})
@JsonInclude(Include.NON_NULL)
public class FileEncryptionInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("encryptionKey")
    protected byte[] encryptionKey;

    @JsonProperty("fileDigest")
    protected byte[] fileDigest;

    @JsonProperty("fileDigestAlgorithm")
    protected String fileDigestAlgorithm;

    @JsonProperty("initializationVector")
    protected byte[] initializationVector;

    @JsonProperty("mac")
    protected byte[] mac;

    @JsonProperty("macKey")
    protected byte[] macKey;

    @JsonProperty("profileIdentifier")
    protected String profileIdentifier;

    protected FileEncryptionInfo() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.fileEncryptionInfo";
    }

    /**
     * <i>“The key used to encrypt the file content.”</i>
     * 
     * @return property encryptionKey
     */
    @Property(name="encryptionKey")
    @JsonIgnore
    public Optional<byte[]> getEncryptionKey() {
        return Optional.ofNullable(encryptionKey);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code encryptionKey}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The key used to encrypt the file content.”</i>
     * 
     * @param encryptionKey
     *            new value of {@code encryptionKey} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code encryptionKey} field changed
     */
    public FileEncryptionInfo withEncryptionKey(byte[] encryptionKey) {
        FileEncryptionInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fileEncryptionInfo");
        _x.encryptionKey = encryptionKey;
        return _x;
    }

    /**
     * <i>“The file digest prior to encryption.”</i>
     * 
     * @return property fileDigest
     */
    @Property(name="fileDigest")
    @JsonIgnore
    public Optional<byte[]> getFileDigest() {
        return Optional.ofNullable(fileDigest);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code fileDigest} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The file digest prior to encryption.”</i>
     * 
     * @param fileDigest
     *            new value of {@code fileDigest} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code fileDigest} field changed
     */
    public FileEncryptionInfo withFileDigest(byte[] fileDigest) {
        FileEncryptionInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fileEncryptionInfo");
        _x.fileDigest = fileDigest;
        return _x;
    }

    /**
     * <i>“The file digest algorithm.”</i>
     * 
     * @return property fileDigestAlgorithm
     */
    @Property(name="fileDigestAlgorithm")
    @JsonIgnore
    public Optional<String> getFileDigestAlgorithm() {
        return Optional.ofNullable(fileDigestAlgorithm);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * fileDigestAlgorithm} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The file digest algorithm.”</i>
     * 
     * @param fileDigestAlgorithm
     *            new value of {@code fileDigestAlgorithm} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code fileDigestAlgorithm} field changed
     */
    public FileEncryptionInfo withFileDigestAlgorithm(String fileDigestAlgorithm) {
        FileEncryptionInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fileEncryptionInfo");
        _x.fileDigestAlgorithm = fileDigestAlgorithm;
        return _x;
    }

    /**
     * <i>“The initialization vector used for the encryption algorithm.”</i>
     * 
     * @return property initializationVector
     */
    @Property(name="initializationVector")
    @JsonIgnore
    public Optional<byte[]> getInitializationVector() {
        return Optional.ofNullable(initializationVector);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * initializationVector} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The initialization vector used for the encryption algorithm.”</i>
     * 
     * @param initializationVector
     *            new value of {@code initializationVector} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code initializationVector} field changed
     */
    public FileEncryptionInfo withInitializationVector(byte[] initializationVector) {
        FileEncryptionInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fileEncryptionInfo");
        _x.initializationVector = initializationVector;
        return _x;
    }

    /**
     * <i>“The hash of the encrypted file content + IV (content hash).”</i>
     * 
     * @return property mac
     */
    @Property(name="mac")
    @JsonIgnore
    public Optional<byte[]> getMac() {
        return Optional.ofNullable(mac);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code mac} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The hash of the encrypted file content + IV (content hash).”</i>
     * 
     * @param mac
     *            new value of {@code mac} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code mac} field changed
     */
    public FileEncryptionInfo withMac(byte[] mac) {
        FileEncryptionInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fileEncryptionInfo");
        _x.mac = mac;
        return _x;
    }

    /**
     * <i>“The key used to get mac.”</i>
     * 
     * @return property macKey
     */
    @Property(name="macKey")
    @JsonIgnore
    public Optional<byte[]> getMacKey() {
        return Optional.ofNullable(macKey);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code macKey} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The key used to get mac.”</i>
     * 
     * @param macKey
     *            new value of {@code macKey} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code macKey} field changed
     */
    public FileEncryptionInfo withMacKey(byte[] macKey) {
        FileEncryptionInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fileEncryptionInfo");
        _x.macKey = macKey;
        return _x;
    }

    /**
     * <i>“The the profile identifier.”</i>
     * 
     * @return property profileIdentifier
     */
    @Property(name="profileIdentifier")
    @JsonIgnore
    public Optional<String> getProfileIdentifier() {
        return Optional.ofNullable(profileIdentifier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code profileIdentifier
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The the profile identifier.”</i>
     * 
     * @param profileIdentifier
     *            new value of {@code profileIdentifier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code profileIdentifier} field changed
     */
    public FileEncryptionInfo withProfileIdentifier(String profileIdentifier) {
        FileEncryptionInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fileEncryptionInfo");
        _x.profileIdentifier = profileIdentifier;
        return _x;
    }

    public FileEncryptionInfo withUnmappedField(String name, Object value) {
        FileEncryptionInfo _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private byte[] encryptionKey;
        private byte[] fileDigest;
        private String fileDigestAlgorithm;
        private byte[] initializationVector;
        private byte[] mac;
        private byte[] macKey;
        private String profileIdentifier;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The key used to encrypt the file content.”</i>
         * 
         * @param encryptionKey
         *            value of {@code encryptionKey} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder encryptionKey(byte[] encryptionKey) {
            this.encryptionKey = encryptionKey;
            this.changedFields = changedFields.add("encryptionKey");
            return this;
        }

        /**
         * <i>“The file digest prior to encryption.”</i>
         * 
         * @param fileDigest
         *            value of {@code fileDigest} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder fileDigest(byte[] fileDigest) {
            this.fileDigest = fileDigest;
            this.changedFields = changedFields.add("fileDigest");
            return this;
        }

        /**
         * <i>“The file digest algorithm.”</i>
         * 
         * @param fileDigestAlgorithm
         *            value of {@code fileDigestAlgorithm} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder fileDigestAlgorithm(String fileDigestAlgorithm) {
            this.fileDigestAlgorithm = fileDigestAlgorithm;
            this.changedFields = changedFields.add("fileDigestAlgorithm");
            return this;
        }

        /**
         * <i>“The initialization vector used for the encryption algorithm.”</i>
         * 
         * @param initializationVector
         *            value of {@code initializationVector} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder initializationVector(byte[] initializationVector) {
            this.initializationVector = initializationVector;
            this.changedFields = changedFields.add("initializationVector");
            return this;
        }

        /**
         * <i>“The hash of the encrypted file content + IV (content hash).”</i>
         * 
         * @param mac
         *            value of {@code mac} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mac(byte[] mac) {
            this.mac = mac;
            this.changedFields = changedFields.add("mac");
            return this;
        }

        /**
         * <i>“The key used to get mac.”</i>
         * 
         * @param macKey
         *            value of {@code macKey} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder macKey(byte[] macKey) {
            this.macKey = macKey;
            this.changedFields = changedFields.add("macKey");
            return this;
        }

        /**
         * <i>“The the profile identifier.”</i>
         * 
         * @param profileIdentifier
         *            value of {@code profileIdentifier} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder profileIdentifier(String profileIdentifier) {
            this.profileIdentifier = profileIdentifier;
            this.changedFields = changedFields.add("profileIdentifier");
            return this;
        }

        public FileEncryptionInfo build() {
            FileEncryptionInfo _x = new FileEncryptionInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.fileEncryptionInfo";
            _x.encryptionKey = encryptionKey;
            _x.fileDigest = fileDigest;
            _x.fileDigestAlgorithm = fileDigestAlgorithm;
            _x.initializationVector = initializationVector;
            _x.mac = mac;
            _x.macKey = macKey;
            _x.profileIdentifier = profileIdentifier;
            return _x;
        }
    }

    private FileEncryptionInfo _copy() {
        FileEncryptionInfo _x = new FileEncryptionInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.encryptionKey = encryptionKey;
        _x.fileDigest = fileDigest;
        _x.fileDigestAlgorithm = fileDigestAlgorithm;
        _x.initializationVector = initializationVector;
        _x.mac = mac;
        _x.macKey = macKey;
        _x.profileIdentifier = profileIdentifier;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("FileEncryptionInfo[");
        b.append("encryptionKey=");
        b.append(this.encryptionKey);
        b.append(", ");
        b.append("fileDigest=");
        b.append(this.fileDigest);
        b.append(", ");
        b.append("fileDigestAlgorithm=");
        b.append(this.fileDigestAlgorithm);
        b.append(", ");
        b.append("initializationVector=");
        b.append(this.initializationVector);
        b.append(", ");
        b.append("mac=");
        b.append(this.mac);
        b.append(", ");
        b.append("macKey=");
        b.append(this.macKey);
        b.append(", ");
        b.append("profileIdentifier=");
        b.append(this.profileIdentifier);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
