package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "hashes", 
    "mimeType", 
    "processingMetadata"})
@JsonInclude(Include.NON_NULL)
public class File implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("hashes")
    protected Hashes hashes;

    @JsonProperty("mimeType")
    protected String mimeType;

    @JsonProperty("processingMetadata")
    protected Boolean processingMetadata;

    protected File() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.file";
    }

    @Property(name="hashes")
    @JsonIgnore
    public Optional<Hashes> getHashes() {
        return Optional.ofNullable(hashes);
    }

    public File withHashes(Hashes hashes) {
        File _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.file");
        _x.hashes = hashes;
        return _x;
    }

    @Property(name="mimeType")
    @JsonIgnore
    public Optional<String> getMimeType() {
        return Optional.ofNullable(mimeType);
    }

    public File withMimeType(String mimeType) {
        File _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.file");
        _x.mimeType = mimeType;
        return _x;
    }

    @Property(name="processingMetadata")
    @JsonIgnore
    public Optional<Boolean> getProcessingMetadata() {
        return Optional.ofNullable(processingMetadata);
    }

    public File withProcessingMetadata(Boolean processingMetadata) {
        File _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.file");
        _x.processingMetadata = processingMetadata;
        return _x;
    }

    public File withUnmappedField(String name, Object value) {
        File _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Hashes hashes;
        private String mimeType;
        private Boolean processingMetadata;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder hashes(Hashes hashes) {
            this.hashes = hashes;
            this.changedFields = changedFields.add("hashes");
            return this;
        }

        public Builder mimeType(String mimeType) {
            this.mimeType = mimeType;
            this.changedFields = changedFields.add("mimeType");
            return this;
        }

        public Builder processingMetadata(Boolean processingMetadata) {
            this.processingMetadata = processingMetadata;
            this.changedFields = changedFields.add("processingMetadata");
            return this;
        }

        public File build() {
            File _x = new File();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.file";
            _x.hashes = hashes;
            _x.mimeType = mimeType;
            _x.processingMetadata = processingMetadata;
            return _x;
        }
    }

    private File _copy() {
        File _x = new File();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.hashes = hashes;
        _x.mimeType = mimeType;
        _x.processingMetadata = processingMetadata;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("File[");
        b.append("hashes=");
        b.append(this.hashes);
        b.append(", ");
        b.append("mimeType=");
        b.append(this.mimeType);
        b.append(", ");
        b.append("processingMetadata=");
        b.append(this.processingMetadata);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
