package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Custom Extended Key Usage definition”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "name", 
    "objectIdentifier"})
@JsonInclude(Include.NON_NULL)
public class ExtendedKeyUsage implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("objectIdentifier")
    protected String objectIdentifier;

    protected ExtendedKeyUsage() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.extendedKeyUsage";
    }

    /**
     * <i>“Extended Key Usage Name”</i>
     * 
     * @return property name
     */
    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code name} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Extended Key Usage Name”</i>
     * 
     * @param name
     *            new value of {@code name} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code name} field changed
     */
    public ExtendedKeyUsage withName(String name) {
        ExtendedKeyUsage _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.extendedKeyUsage");
        _x.name = name;
        return _x;
    }

    /**
     * <i>“Extended Key Usage Object Identifier”</i>
     * 
     * @return property objectIdentifier
     */
    @Property(name="objectIdentifier")
    @JsonIgnore
    public Optional<String> getObjectIdentifier() {
        return Optional.ofNullable(objectIdentifier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code objectIdentifier}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Extended Key Usage Object Identifier”</i>
     * 
     * @param objectIdentifier
     *            new value of {@code objectIdentifier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code objectIdentifier} field changed
     */
    public ExtendedKeyUsage withObjectIdentifier(String objectIdentifier) {
        ExtendedKeyUsage _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.extendedKeyUsage");
        _x.objectIdentifier = objectIdentifier;
        return _x;
    }

    public ExtendedKeyUsage withUnmappedField(String name, Object value) {
        ExtendedKeyUsage _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private String objectIdentifier;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Extended Key Usage Name”</i>
         * 
         * @param name
         *            value of {@code name} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        /**
         * <i>“Extended Key Usage Object Identifier”</i>
         * 
         * @param objectIdentifier
         *            value of {@code objectIdentifier} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder objectIdentifier(String objectIdentifier) {
            this.objectIdentifier = objectIdentifier;
            this.changedFields = changedFields.add("objectIdentifier");
            return this;
        }

        public ExtendedKeyUsage build() {
            ExtendedKeyUsage _x = new ExtendedKeyUsage();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.extendedKeyUsage";
            _x.name = name;
            _x.objectIdentifier = objectIdentifier;
            return _x;
        }
    }

    private ExtendedKeyUsage _copy() {
        ExtendedKeyUsage _x = new ExtendedKeyUsage();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.name = name;
        _x.objectIdentifier = objectIdentifier;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ExtendedKeyUsage[");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("objectIdentifier=");
        b.append(this.objectIdentifier);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
