package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "expression", 
    "expressionEvaluationDetails", 
    "expressionResult", 
    "propertyToEvaluate"})
@JsonInclude(Include.NON_NULL)
public class ExpressionEvaluationDetails implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("expression")
    protected String expression;

    @JsonProperty("expressionEvaluationDetails")
    protected List<ExpressionEvaluationDetails> expressionEvaluationDetails;

    @JsonProperty("expressionEvaluationDetails@nextLink")
    protected String expressionEvaluationDetailsNextLink;

    @JsonProperty("expressionResult")
    protected Boolean expressionResult;

    @JsonProperty("propertyToEvaluate")
    protected PropertyToEvaluate propertyToEvaluate;

    protected ExpressionEvaluationDetails() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.expressionEvaluationDetails";
    }

    @Property(name="expression")
    @JsonIgnore
    public Optional<String> getExpression() {
        return Optional.ofNullable(expression);
    }

    public ExpressionEvaluationDetails withExpression(String expression) {
        ExpressionEvaluationDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.expressionEvaluationDetails");
        _x.expression = expression;
        return _x;
    }

    @Property(name="expressionEvaluationDetails")
    @JsonIgnore
    public CollectionPage<ExpressionEvaluationDetails> getExpressionEvaluationDetails() {
        return new CollectionPage<ExpressionEvaluationDetails>(contextPath, ExpressionEvaluationDetails.class, this.expressionEvaluationDetails, Optional.ofNullable(expressionEvaluationDetailsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="expressionEvaluationDetails")
    @JsonIgnore
    public CollectionPage<ExpressionEvaluationDetails> getExpressionEvaluationDetails(HttpRequestOptions options) {
        return new CollectionPage<ExpressionEvaluationDetails>(contextPath, ExpressionEvaluationDetails.class, this.expressionEvaluationDetails, Optional.ofNullable(expressionEvaluationDetailsNextLink), Collections.emptyList(), options);
    }

    @Property(name="expressionResult")
    @JsonIgnore
    public Optional<Boolean> getExpressionResult() {
        return Optional.ofNullable(expressionResult);
    }

    public ExpressionEvaluationDetails withExpressionResult(Boolean expressionResult) {
        ExpressionEvaluationDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.expressionEvaluationDetails");
        _x.expressionResult = expressionResult;
        return _x;
    }

    @Property(name="propertyToEvaluate")
    @JsonIgnore
    public Optional<PropertyToEvaluate> getPropertyToEvaluate() {
        return Optional.ofNullable(propertyToEvaluate);
    }

    public ExpressionEvaluationDetails withPropertyToEvaluate(PropertyToEvaluate propertyToEvaluate) {
        ExpressionEvaluationDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.expressionEvaluationDetails");
        _x.propertyToEvaluate = propertyToEvaluate;
        return _x;
    }

    public ExpressionEvaluationDetails withUnmappedField(String name, Object value) {
        ExpressionEvaluationDetails _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String expression;
        private List<ExpressionEvaluationDetails> expressionEvaluationDetails;
        private String expressionEvaluationDetailsNextLink;
        private Boolean expressionResult;
        private PropertyToEvaluate propertyToEvaluate;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder expression(String expression) {
            this.expression = expression;
            this.changedFields = changedFields.add("expression");
            return this;
        }

        public Builder expressionEvaluationDetails(List<ExpressionEvaluationDetails> expressionEvaluationDetails) {
            this.expressionEvaluationDetails = expressionEvaluationDetails;
            this.changedFields = changedFields.add("expressionEvaluationDetails");
            return this;
        }

        public Builder expressionEvaluationDetails(ExpressionEvaluationDetails... expressionEvaluationDetails) {
            return expressionEvaluationDetails(Arrays.asList(expressionEvaluationDetails));
        }

        public Builder expressionEvaluationDetailsNextLink(String expressionEvaluationDetailsNextLink) {
            this.expressionEvaluationDetailsNextLink = expressionEvaluationDetailsNextLink;
            this.changedFields = changedFields.add("expressionEvaluationDetails");
            return this;
        }

        public Builder expressionResult(Boolean expressionResult) {
            this.expressionResult = expressionResult;
            this.changedFields = changedFields.add("expressionResult");
            return this;
        }

        public Builder propertyToEvaluate(PropertyToEvaluate propertyToEvaluate) {
            this.propertyToEvaluate = propertyToEvaluate;
            this.changedFields = changedFields.add("propertyToEvaluate");
            return this;
        }

        public ExpressionEvaluationDetails build() {
            ExpressionEvaluationDetails _x = new ExpressionEvaluationDetails();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.expressionEvaluationDetails";
            _x.expression = expression;
            _x.expressionEvaluationDetails = expressionEvaluationDetails;
            _x.expressionEvaluationDetailsNextLink = expressionEvaluationDetailsNextLink;
            _x.expressionResult = expressionResult;
            _x.propertyToEvaluate = propertyToEvaluate;
            return _x;
        }
    }

    private ExpressionEvaluationDetails _copy() {
        ExpressionEvaluationDetails _x = new ExpressionEvaluationDetails();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.expression = expression;
        _x.expressionEvaluationDetails = expressionEvaluationDetails;
        _x.expressionResult = expressionResult;
        _x.propertyToEvaluate = propertyToEvaluate;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ExpressionEvaluationDetails[");
        b.append("expression=");
        b.append(this.expression);
        b.append(", ");
        b.append("expressionEvaluationDetails=");
        b.append(this.expressionEvaluationDetails);
        b.append(", ");
        b.append("expressionResult=");
        b.append(this.expressionResult);
        b.append(", ");
        b.append("propertyToEvaluate=");
        b.append(this.propertyToEvaluate);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
