package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“A complex type to store the expedited quality update settings such as release
 * date and days until forced reboot.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "daysUntilForcedReboot", 
    "qualityUpdateRelease"})
@JsonInclude(Include.NON_NULL)
public class ExpeditedWindowsQualityUpdateSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("daysUntilForcedReboot")
    protected Integer daysUntilForcedReboot;

    @JsonProperty("qualityUpdateRelease")
    protected String qualityUpdateRelease;

    protected ExpeditedWindowsQualityUpdateSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.expeditedWindowsQualityUpdateSettings";
    }

    /**
     * <i>“The number of days after installation that forced reboot will happen.”</i>
     * 
     * @return property daysUntilForcedReboot
     */
    @Property(name="daysUntilForcedReboot")
    @JsonIgnore
    public Optional<Integer> getDaysUntilForcedReboot() {
        return Optional.ofNullable(daysUntilForcedReboot);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * daysUntilForcedReboot} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The number of days after installation that forced reboot will happen.”</i>
     * 
     * @param daysUntilForcedReboot
     *            new value of {@code daysUntilForcedReboot} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code daysUntilForcedReboot} field changed
     */
    public ExpeditedWindowsQualityUpdateSettings withDaysUntilForcedReboot(Integer daysUntilForcedReboot) {
        ExpeditedWindowsQualityUpdateSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.expeditedWindowsQualityUpdateSettings");
        _x.daysUntilForcedReboot = daysUntilForcedReboot;
        return _x;
    }

    /**
     * <i>“The release date to identify a quality update.”</i>
     * 
     * @return property qualityUpdateRelease
     */
    @Property(name="qualityUpdateRelease")
    @JsonIgnore
    public Optional<String> getQualityUpdateRelease() {
        return Optional.ofNullable(qualityUpdateRelease);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * qualityUpdateRelease} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The release date to identify a quality update.”</i>
     * 
     * @param qualityUpdateRelease
     *            new value of {@code qualityUpdateRelease} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code qualityUpdateRelease} field changed
     */
    public ExpeditedWindowsQualityUpdateSettings withQualityUpdateRelease(String qualityUpdateRelease) {
        ExpeditedWindowsQualityUpdateSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.expeditedWindowsQualityUpdateSettings");
        _x.qualityUpdateRelease = qualityUpdateRelease;
        return _x;
    }

    public ExpeditedWindowsQualityUpdateSettings withUnmappedField(String name, Object value) {
        ExpeditedWindowsQualityUpdateSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer daysUntilForcedReboot;
        private String qualityUpdateRelease;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The number of days after installation that forced reboot will happen.”</i>
         * 
         * @param daysUntilForcedReboot
         *            value of {@code daysUntilForcedReboot} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder daysUntilForcedReboot(Integer daysUntilForcedReboot) {
            this.daysUntilForcedReboot = daysUntilForcedReboot;
            this.changedFields = changedFields.add("daysUntilForcedReboot");
            return this;
        }

        /**
         * <i>“The release date to identify a quality update.”</i>
         * 
         * @param qualityUpdateRelease
         *            value of {@code qualityUpdateRelease} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder qualityUpdateRelease(String qualityUpdateRelease) {
            this.qualityUpdateRelease = qualityUpdateRelease;
            this.changedFields = changedFields.add("qualityUpdateRelease");
            return this;
        }

        public ExpeditedWindowsQualityUpdateSettings build() {
            ExpeditedWindowsQualityUpdateSettings _x = new ExpeditedWindowsQualityUpdateSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.expeditedWindowsQualityUpdateSettings";
            _x.daysUntilForcedReboot = daysUntilForcedReboot;
            _x.qualityUpdateRelease = qualityUpdateRelease;
            return _x;
        }
    }

    private ExpeditedWindowsQualityUpdateSettings _copy() {
        ExpeditedWindowsQualityUpdateSettings _x = new ExpeditedWindowsQualityUpdateSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.daysUntilForcedReboot = daysUntilForcedReboot;
        _x.qualityUpdateRelease = qualityUpdateRelease;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ExpeditedWindowsQualityUpdateSettings[");
        b.append("daysUntilForcedReboot=");
        b.append(this.daysUntilForcedReboot);
        b.append(", ");
        b.append("qualityUpdateRelease=");
        b.append(this.qualityUpdateRelease);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
