package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "ignoredDelimiters", 
    "isCaseInsensitive", 
    "isSearchable", 
    "name"})
@JsonInclude(Include.NON_NULL)
public class ExactDataMatchStoreColumn implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ignoredDelimiters")
    protected List<String> ignoredDelimiters;

    @JsonProperty("ignoredDelimiters@nextLink")
    protected String ignoredDelimitersNextLink;

    @JsonProperty("isCaseInsensitive")
    protected Boolean isCaseInsensitive;

    @JsonProperty("isSearchable")
    protected Boolean isSearchable;

    @JsonProperty("name")
    protected String name;

    protected ExactDataMatchStoreColumn() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.exactDataMatchStoreColumn";
    }

    @Property(name="ignoredDelimiters")
    @JsonIgnore
    public CollectionPage<String> getIgnoredDelimiters() {
        return new CollectionPage<String>(contextPath, String.class, this.ignoredDelimiters, Optional.ofNullable(ignoredDelimitersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="ignoredDelimiters")
    @JsonIgnore
    public CollectionPage<String> getIgnoredDelimiters(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.ignoredDelimiters, Optional.ofNullable(ignoredDelimitersNextLink), Collections.emptyList(), options);
    }

    @Property(name="isCaseInsensitive")
    @JsonIgnore
    public Optional<Boolean> getIsCaseInsensitive() {
        return Optional.ofNullable(isCaseInsensitive);
    }

    public ExactDataMatchStoreColumn withIsCaseInsensitive(Boolean isCaseInsensitive) {
        ExactDataMatchStoreColumn _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactDataMatchStoreColumn");
        _x.isCaseInsensitive = isCaseInsensitive;
        return _x;
    }

    @Property(name="isSearchable")
    @JsonIgnore
    public Optional<Boolean> getIsSearchable() {
        return Optional.ofNullable(isSearchable);
    }

    public ExactDataMatchStoreColumn withIsSearchable(Boolean isSearchable) {
        ExactDataMatchStoreColumn _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactDataMatchStoreColumn");
        _x.isSearchable = isSearchable;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public ExactDataMatchStoreColumn withName(String name) {
        ExactDataMatchStoreColumn _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactDataMatchStoreColumn");
        _x.name = name;
        return _x;
    }

    public ExactDataMatchStoreColumn withUnmappedField(String name, Object value) {
        ExactDataMatchStoreColumn _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> ignoredDelimiters;
        private String ignoredDelimitersNextLink;
        private Boolean isCaseInsensitive;
        private Boolean isSearchable;
        private String name;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder ignoredDelimiters(List<String> ignoredDelimiters) {
            this.ignoredDelimiters = ignoredDelimiters;
            this.changedFields = changedFields.add("ignoredDelimiters");
            return this;
        }

        public Builder ignoredDelimiters(String... ignoredDelimiters) {
            return ignoredDelimiters(Arrays.asList(ignoredDelimiters));
        }

        public Builder ignoredDelimitersNextLink(String ignoredDelimitersNextLink) {
            this.ignoredDelimitersNextLink = ignoredDelimitersNextLink;
            this.changedFields = changedFields.add("ignoredDelimiters");
            return this;
        }

        public Builder isCaseInsensitive(Boolean isCaseInsensitive) {
            this.isCaseInsensitive = isCaseInsensitive;
            this.changedFields = changedFields.add("isCaseInsensitive");
            return this;
        }

        public Builder isSearchable(Boolean isSearchable) {
            this.isSearchable = isSearchable;
            this.changedFields = changedFields.add("isSearchable");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public ExactDataMatchStoreColumn build() {
            ExactDataMatchStoreColumn _x = new ExactDataMatchStoreColumn();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.exactDataMatchStoreColumn";
            _x.ignoredDelimiters = ignoredDelimiters;
            _x.ignoredDelimitersNextLink = ignoredDelimitersNextLink;
            _x.isCaseInsensitive = isCaseInsensitive;
            _x.isSearchable = isSearchable;
            _x.name = name;
            return _x;
        }
    }

    private ExactDataMatchStoreColumn _copy() {
        ExactDataMatchStoreColumn _x = new ExactDataMatchStoreColumn();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.ignoredDelimiters = ignoredDelimiters;
        _x.isCaseInsensitive = isCaseInsensitive;
        _x.isSearchable = isSearchable;
        _x.name = name;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ExactDataMatchStoreColumn[");
        b.append("ignoredDelimiters=");
        b.append(this.ignoredDelimiters);
        b.append(", ");
        b.append("isCaseInsensitive=");
        b.append(this.isCaseInsensitive);
        b.append(", ");
        b.append("isSearchable=");
        b.append(this.isSearchable);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
