package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Policy Details for Encryption Report”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "policyId", 
    "policyName"})
@JsonInclude(Include.NON_NULL)
public class EncryptionReportPolicyDetails implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("policyId")
    protected String policyId;

    @JsonProperty("policyName")
    protected String policyName;

    protected EncryptionReportPolicyDetails() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.encryptionReportPolicyDetails";
    }

    /**
     * <i>“Policy Id for Encryption Report”</i>
     * 
     * @return property policyId
     */
    @Property(name="policyId")
    @JsonIgnore
    public Optional<String> getPolicyId() {
        return Optional.ofNullable(policyId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code policyId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Policy Id for Encryption Report”</i>
     * 
     * @param policyId
     *            new value of {@code policyId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code policyId} field changed
     */
    public EncryptionReportPolicyDetails withPolicyId(String policyId) {
        EncryptionReportPolicyDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.encryptionReportPolicyDetails");
        _x.policyId = policyId;
        return _x;
    }

    /**
     * <i>“Policy Name for Encryption Report”</i>
     * 
     * @return property policyName
     */
    @Property(name="policyName")
    @JsonIgnore
    public Optional<String> getPolicyName() {
        return Optional.ofNullable(policyName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code policyName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Policy Name for Encryption Report”</i>
     * 
     * @param policyName
     *            new value of {@code policyName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code policyName} field changed
     */
    public EncryptionReportPolicyDetails withPolicyName(String policyName) {
        EncryptionReportPolicyDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.encryptionReportPolicyDetails");
        _x.policyName = policyName;
        return _x;
    }

    public EncryptionReportPolicyDetails withUnmappedField(String name, Object value) {
        EncryptionReportPolicyDetails _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String policyId;
        private String policyName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Policy Id for Encryption Report”</i>
         * 
         * @param policyId
         *            value of {@code policyId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder policyId(String policyId) {
            this.policyId = policyId;
            this.changedFields = changedFields.add("policyId");
            return this;
        }

        /**
         * <i>“Policy Name for Encryption Report”</i>
         * 
         * @param policyName
         *            value of {@code policyName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder policyName(String policyName) {
            this.policyName = policyName;
            this.changedFields = changedFields.add("policyName");
            return this;
        }

        public EncryptionReportPolicyDetails build() {
            EncryptionReportPolicyDetails _x = new EncryptionReportPolicyDetails();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.encryptionReportPolicyDetails";
            _x.policyId = policyId;
            _x.policyName = policyName;
            return _x;
        }
    }

    private EncryptionReportPolicyDetails _copy() {
        EncryptionReportPolicyDetails _x = new EncryptionReportPolicyDetails();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.policyId = policyId;
        _x.policyName = policyName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EncryptionReportPolicyDetails[");
        b.append("policyId=");
        b.append(this.policyId);
        b.append(", ");
        b.append("policyName=");
        b.append(this.policyName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
