package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "costCenter", 
    "division"})
@JsonInclude(Include.NON_NULL)
public class EmployeeOrgData implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("costCenter")
    protected String costCenter;

    @JsonProperty("division")
    protected String division;

    protected EmployeeOrgData() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.employeeOrgData";
    }

    @Property(name="costCenter")
    @JsonIgnore
    public Optional<String> getCostCenter() {
        return Optional.ofNullable(costCenter);
    }

    public EmployeeOrgData withCostCenter(String costCenter) {
        EmployeeOrgData _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.employeeOrgData");
        _x.costCenter = costCenter;
        return _x;
    }

    @Property(name="division")
    @JsonIgnore
    public Optional<String> getDivision() {
        return Optional.ofNullable(division);
    }

    public EmployeeOrgData withDivision(String division) {
        EmployeeOrgData _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.employeeOrgData");
        _x.division = division;
        return _x;
    }

    public EmployeeOrgData withUnmappedField(String name, Object value) {
        EmployeeOrgData _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String costCenter;
        private String division;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder costCenter(String costCenter) {
            this.costCenter = costCenter;
            this.changedFields = changedFields.add("costCenter");
            return this;
        }

        public Builder division(String division) {
            this.division = division;
            this.changedFields = changedFields.add("division");
            return this;
        }

        public EmployeeOrgData build() {
            EmployeeOrgData _x = new EmployeeOrgData();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.employeeOrgData";
            _x.costCenter = costCenter;
            _x.division = division;
            return _x;
        }
    }

    private EmployeeOrgData _copy() {
        EmployeeOrgData _x = new EmployeeOrgData();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.costCenter = costCenter;
        _x.division = division;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EmployeeOrgData[");
        b.append("costCenter=");
        b.append(this.costCenter);
        b.append(", ");
        b.append("division=");
        b.append(this.division);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
