package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;

@JsonPropertyOrder({
    "@odata.type"})
@JsonInclude(Include.NON_NULL)
public class EducationSynchronizationOAuth1ConnectionSettings extends EducationSynchronizationConnectionSettings implements ODataType {

    protected EducationSynchronizationOAuth1ConnectionSettings() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationSynchronizationOAuth1ConnectionSettings";
    }

    public EducationSynchronizationOAuth1ConnectionSettings withUnmappedField(String name, Object value) {
        EducationSynchronizationOAuth1ConnectionSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEducationSynchronizationOAuth1ConnectionSettings() {
        return new Builder();
    }

    public static final class Builder {
        private String clientId;
        private String clientSecret;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            this.changedFields = changedFields.add("clientId");
            return this;
        }

        public Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            this.changedFields = changedFields.add("clientSecret");
            return this;
        }

        public EducationSynchronizationOAuth1ConnectionSettings build() {
            EducationSynchronizationOAuth1ConnectionSettings _x = new EducationSynchronizationOAuth1ConnectionSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.educationSynchronizationOAuth1ConnectionSettings";
            _x.clientId = clientId;
            _x.clientSecret = clientSecret;
            return _x;
        }
    }

    private EducationSynchronizationOAuth1ConnectionSettings _copy() {
        EducationSynchronizationOAuth1ConnectionSettings _x = new EducationSynchronizationOAuth1ConnectionSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.clientId = clientId;
        _x.clientSecret = clientSecret;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationSynchronizationOAuth1ConnectionSettings[");
        b.append("clientId=");
        b.append(this.clientId);
        b.append(", ");
        b.append("clientSecret=");
        b.append(this.clientSecret);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
