package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "school", 
    "section", 
    "student", 
    "studentEnrollment", 
    "teacher", 
    "teacherRoster"})
@JsonInclude(Include.NON_NULL)
public class EducationSynchronizationCustomizations extends EducationSynchronizationCustomizationsBase implements ODataType {

    @JsonProperty("school")
    protected EducationSynchronizationCustomization school;

    @JsonProperty("section")
    protected EducationSynchronizationCustomization section;

    @JsonProperty("student")
    protected EducationSynchronizationCustomization student;

    @JsonProperty("studentEnrollment")
    protected EducationSynchronizationCustomization studentEnrollment;

    @JsonProperty("teacher")
    protected EducationSynchronizationCustomization teacher;

    @JsonProperty("teacherRoster")
    protected EducationSynchronizationCustomization teacherRoster;

    protected EducationSynchronizationCustomizations() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationSynchronizationCustomizations";
    }

    @Property(name="school")
    @JsonIgnore
    public Optional<EducationSynchronizationCustomization> getSchool() {
        return Optional.ofNullable(school);
    }

    public EducationSynchronizationCustomizations withSchool(EducationSynchronizationCustomization school) {
        EducationSynchronizationCustomizations _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSynchronizationCustomizations");
        _x.school = school;
        return _x;
    }

    @Property(name="section")
    @JsonIgnore
    public Optional<EducationSynchronizationCustomization> getSection() {
        return Optional.ofNullable(section);
    }

    public EducationSynchronizationCustomizations withSection(EducationSynchronizationCustomization section) {
        EducationSynchronizationCustomizations _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSynchronizationCustomizations");
        _x.section = section;
        return _x;
    }

    @Property(name="student")
    @JsonIgnore
    public Optional<EducationSynchronizationCustomization> getStudent() {
        return Optional.ofNullable(student);
    }

    public EducationSynchronizationCustomizations withStudent(EducationSynchronizationCustomization student) {
        EducationSynchronizationCustomizations _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSynchronizationCustomizations");
        _x.student = student;
        return _x;
    }

    @Property(name="studentEnrollment")
    @JsonIgnore
    public Optional<EducationSynchronizationCustomization> getStudentEnrollment() {
        return Optional.ofNullable(studentEnrollment);
    }

    public EducationSynchronizationCustomizations withStudentEnrollment(EducationSynchronizationCustomization studentEnrollment) {
        EducationSynchronizationCustomizations _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSynchronizationCustomizations");
        _x.studentEnrollment = studentEnrollment;
        return _x;
    }

    @Property(name="teacher")
    @JsonIgnore
    public Optional<EducationSynchronizationCustomization> getTeacher() {
        return Optional.ofNullable(teacher);
    }

    public EducationSynchronizationCustomizations withTeacher(EducationSynchronizationCustomization teacher) {
        EducationSynchronizationCustomizations _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSynchronizationCustomizations");
        _x.teacher = teacher;
        return _x;
    }

    @Property(name="teacherRoster")
    @JsonIgnore
    public Optional<EducationSynchronizationCustomization> getTeacherRoster() {
        return Optional.ofNullable(teacherRoster);
    }

    public EducationSynchronizationCustomizations withTeacherRoster(EducationSynchronizationCustomization teacherRoster) {
        EducationSynchronizationCustomizations _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSynchronizationCustomizations");
        _x.teacherRoster = teacherRoster;
        return _x;
    }

    public EducationSynchronizationCustomizations withUnmappedField(String name, Object value) {
        EducationSynchronizationCustomizations _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEducationSynchronizationCustomizations() {
        return new Builder();
    }

    public static final class Builder {
        private EducationSynchronizationCustomization school;
        private EducationSynchronizationCustomization section;
        private EducationSynchronizationCustomization student;
        private EducationSynchronizationCustomization studentEnrollment;
        private EducationSynchronizationCustomization teacher;
        private EducationSynchronizationCustomization teacherRoster;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder school(EducationSynchronizationCustomization school) {
            this.school = school;
            this.changedFields = changedFields.add("school");
            return this;
        }

        public Builder section(EducationSynchronizationCustomization section) {
            this.section = section;
            this.changedFields = changedFields.add("section");
            return this;
        }

        public Builder student(EducationSynchronizationCustomization student) {
            this.student = student;
            this.changedFields = changedFields.add("student");
            return this;
        }

        public Builder studentEnrollment(EducationSynchronizationCustomization studentEnrollment) {
            this.studentEnrollment = studentEnrollment;
            this.changedFields = changedFields.add("studentEnrollment");
            return this;
        }

        public Builder teacher(EducationSynchronizationCustomization teacher) {
            this.teacher = teacher;
            this.changedFields = changedFields.add("teacher");
            return this;
        }

        public Builder teacherRoster(EducationSynchronizationCustomization teacherRoster) {
            this.teacherRoster = teacherRoster;
            this.changedFields = changedFields.add("teacherRoster");
            return this;
        }

        public EducationSynchronizationCustomizations build() {
            EducationSynchronizationCustomizations _x = new EducationSynchronizationCustomizations();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.educationSynchronizationCustomizations";
            _x.school = school;
            _x.section = section;
            _x.student = student;
            _x.studentEnrollment = studentEnrollment;
            _x.teacher = teacher;
            _x.teacherRoster = teacherRoster;
            return _x;
        }
    }

    private EducationSynchronizationCustomizations _copy() {
        EducationSynchronizationCustomizations _x = new EducationSynchronizationCustomizations();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.school = school;
        _x.section = section;
        _x.student = student;
        _x.studentEnrollment = studentEnrollment;
        _x.teacher = teacher;
        _x.teacherRoster = teacherRoster;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationSynchronizationCustomizations[");
        b.append("school=");
        b.append(this.school);
        b.append(", ");
        b.append("section=");
        b.append(this.section);
        b.append(", ");
        b.append("student=");
        b.append(this.student);
        b.append(", ");
        b.append("studentEnrollment=");
        b.append(this.studentEnrollment);
        b.append(", ");
        b.append("teacher=");
        b.append(this.teacher);
        b.append(", ");
        b.append("teacherRoster=");
        b.append(this.teacherRoster);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
