package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "userDomains"})
@JsonInclude(Include.NON_NULL)
public class EducationIdentityCreationConfiguration extends EducationIdentitySynchronizationConfiguration implements ODataType {

    @JsonProperty("userDomains")
    protected List<EducationIdentityDomain> userDomains;

    @JsonProperty("userDomains@nextLink")
    protected String userDomainsNextLink;

    protected EducationIdentityCreationConfiguration() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationIdentityCreationConfiguration";
    }

    @Property(name="userDomains")
    @JsonIgnore
    public CollectionPage<EducationIdentityDomain> getUserDomains() {
        return new CollectionPage<EducationIdentityDomain>(contextPath, EducationIdentityDomain.class, this.userDomains, Optional.ofNullable(userDomainsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="userDomains")
    @JsonIgnore
    public CollectionPage<EducationIdentityDomain> getUserDomains(HttpRequestOptions options) {
        return new CollectionPage<EducationIdentityDomain>(contextPath, EducationIdentityDomain.class, this.userDomains, Optional.ofNullable(userDomainsNextLink), Collections.emptyList(), options);
    }

    public EducationIdentityCreationConfiguration withUnmappedField(String name, Object value) {
        EducationIdentityCreationConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEducationIdentityCreationConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private List<EducationIdentityDomain> userDomains;
        private String userDomainsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder userDomains(List<EducationIdentityDomain> userDomains) {
            this.userDomains = userDomains;
            this.changedFields = changedFields.add("userDomains");
            return this;
        }

        public Builder userDomains(EducationIdentityDomain... userDomains) {
            return userDomains(Arrays.asList(userDomains));
        }

        public Builder userDomainsNextLink(String userDomainsNextLink) {
            this.userDomainsNextLink = userDomainsNextLink;
            this.changedFields = changedFields.add("userDomains");
            return this;
        }

        public EducationIdentityCreationConfiguration build() {
            EducationIdentityCreationConfiguration _x = new EducationIdentityCreationConfiguration();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.educationIdentityCreationConfiguration";
            _x.userDomains = userDomains;
            _x.userDomainsNextLink = userDomainsNextLink;
            return _x;
        }
    }

    private EducationIdentityCreationConfiguration _copy() {
        EducationIdentityCreationConfiguration _x = new EducationIdentityCreationConfiguration();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.userDomains = userDomains;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationIdentityCreationConfiguration[");
        b.append("userDomains=");
        b.append(this.userDomains);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
