package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Float;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "maxPoints"})
@JsonInclude(Include.NON_NULL)
public class EducationAssignmentPointsGradeType extends EducationAssignmentGradeType implements ODataType {

    @JsonProperty("maxPoints")
    protected Float maxPoints;

    protected EducationAssignmentPointsGradeType() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationAssignmentPointsGradeType";
    }

    @Property(name="maxPoints")
    @JsonIgnore
    public Optional<Float> getMaxPoints() {
        return Optional.ofNullable(maxPoints);
    }

    public EducationAssignmentPointsGradeType withMaxPoints(Float maxPoints) {
        EducationAssignmentPointsGradeType _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignmentPointsGradeType");
        _x.maxPoints = maxPoints;
        return _x;
    }

    public EducationAssignmentPointsGradeType withUnmappedField(String name, Object value) {
        EducationAssignmentPointsGradeType _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEducationAssignmentPointsGradeType() {
        return new Builder();
    }

    public static final class Builder {
        private Float maxPoints;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder maxPoints(Float maxPoints) {
            this.maxPoints = maxPoints;
            this.changedFields = changedFields.add("maxPoints");
            return this;
        }

        public EducationAssignmentPointsGradeType build() {
            EducationAssignmentPointsGradeType _x = new EducationAssignmentPointsGradeType();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.educationAssignmentPointsGradeType";
            _x.maxPoints = maxPoints;
            return _x;
        }
    }

    private EducationAssignmentPointsGradeType _copy() {
        EducationAssignmentPointsGradeType _x = new EducationAssignmentPointsGradeType();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.maxPoints = maxPoints;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationAssignmentPointsGradeType[");
        b.append("maxPoints=");
        b.append(this.maxPoints);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
