package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "description", 
    "fileSize", 
    "fileSystemInfo", 
    "name"})
@JsonInclude(Include.NON_NULL)
public class DriveItemUploadableProperties implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("fileSize")
    protected Long fileSize;

    @JsonProperty("fileSystemInfo")
    protected FileSystemInfo fileSystemInfo;

    @JsonProperty("name")
    protected String name;

    protected DriveItemUploadableProperties() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.driveItemUploadableProperties";
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public DriveItemUploadableProperties withDescription(String description) {
        DriveItemUploadableProperties _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.driveItemUploadableProperties");
        _x.description = description;
        return _x;
    }

    @Property(name="fileSize")
    @JsonIgnore
    public Optional<Long> getFileSize() {
        return Optional.ofNullable(fileSize);
    }

    public DriveItemUploadableProperties withFileSize(Long fileSize) {
        DriveItemUploadableProperties _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.driveItemUploadableProperties");
        _x.fileSize = fileSize;
        return _x;
    }

    @Property(name="fileSystemInfo")
    @JsonIgnore
    public Optional<FileSystemInfo> getFileSystemInfo() {
        return Optional.ofNullable(fileSystemInfo);
    }

    public DriveItemUploadableProperties withFileSystemInfo(FileSystemInfo fileSystemInfo) {
        DriveItemUploadableProperties _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.driveItemUploadableProperties");
        _x.fileSystemInfo = fileSystemInfo;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public DriveItemUploadableProperties withName(String name) {
        DriveItemUploadableProperties _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.driveItemUploadableProperties");
        _x.name = name;
        return _x;
    }

    public DriveItemUploadableProperties withUnmappedField(String name, Object value) {
        DriveItemUploadableProperties _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String description;
        private Long fileSize;
        private FileSystemInfo fileSystemInfo;
        private String name;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder fileSize(Long fileSize) {
            this.fileSize = fileSize;
            this.changedFields = changedFields.add("fileSize");
            return this;
        }

        public Builder fileSystemInfo(FileSystemInfo fileSystemInfo) {
            this.fileSystemInfo = fileSystemInfo;
            this.changedFields = changedFields.add("fileSystemInfo");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public DriveItemUploadableProperties build() {
            DriveItemUploadableProperties _x = new DriveItemUploadableProperties();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.driveItemUploadableProperties";
            _x.description = description;
            _x.fileSize = fileSize;
            _x.fileSystemInfo = fileSystemInfo;
            _x.name = name;
            return _x;
        }
    }

    private DriveItemUploadableProperties _copy() {
        DriveItemUploadableProperties _x = new DriveItemUploadableProperties();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.description = description;
        _x.fileSize = fileSize;
        _x.fileSystemInfo = fileSystemInfo;
        _x.name = name;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DriveItemUploadableProperties[");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("fileSize=");
        b.append(this.fileSize);
        b.append(", ");
        b.append("fileSystemInfo=");
        b.append(this.fileSystemInfo);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
