package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DriveItemSourceApplication;

@JsonPropertyOrder({
    "@odata.type", 
    "application", 
    "externalId"})
@JsonInclude(Include.NON_NULL)
public class DriveItemSource implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("application")
    protected DriveItemSourceApplication application;

    @JsonProperty("externalId")
    protected String externalId;

    protected DriveItemSource() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.driveItemSource";
    }

    @Property(name="application")
    @JsonIgnore
    public Optional<DriveItemSourceApplication> getApplication() {
        return Optional.ofNullable(application);
    }

    public DriveItemSource withApplication(DriveItemSourceApplication application) {
        DriveItemSource _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.driveItemSource");
        _x.application = application;
        return _x;
    }

    @Property(name="externalId")
    @JsonIgnore
    public Optional<String> getExternalId() {
        return Optional.ofNullable(externalId);
    }

    public DriveItemSource withExternalId(String externalId) {
        DriveItemSource _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.driveItemSource");
        _x.externalId = externalId;
        return _x;
    }

    public DriveItemSource withUnmappedField(String name, Object value) {
        DriveItemSource _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private DriveItemSourceApplication application;
        private String externalId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder application(DriveItemSourceApplication application) {
            this.application = application;
            this.changedFields = changedFields.add("application");
            return this;
        }

        public Builder externalId(String externalId) {
            this.externalId = externalId;
            this.changedFields = changedFields.add("externalId");
            return this;
        }

        public DriveItemSource build() {
            DriveItemSource _x = new DriveItemSource();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.driveItemSource";
            _x.application = application;
            _x.externalId = externalId;
            return _x;
        }
    }

    private DriveItemSource _copy() {
        DriveItemSource _x = new DriveItemSource();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.application = application;
        _x.externalId = externalId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DriveItemSource[");
        b.append("application=");
        b.append(this.application);
        b.append(", ");
        b.append("externalId=");
        b.append(this.externalId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
