package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "lastActionDateTime", 
    "operation", 
    "status"})
@JsonInclude(Include.NON_NULL)
public class DomainState implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("lastActionDateTime")
    protected OffsetDateTime lastActionDateTime;

    @JsonProperty("operation")
    protected String operation;

    @JsonProperty("status")
    protected String status;

    protected DomainState() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.domainState";
    }

    @Property(name="lastActionDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastActionDateTime() {
        return Optional.ofNullable(lastActionDateTime);
    }

    public DomainState withLastActionDateTime(OffsetDateTime lastActionDateTime) {
        DomainState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.domainState");
        _x.lastActionDateTime = lastActionDateTime;
        return _x;
    }

    @Property(name="operation")
    @JsonIgnore
    public Optional<String> getOperation() {
        return Optional.ofNullable(operation);
    }

    public DomainState withOperation(String operation) {
        DomainState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.domainState");
        _x.operation = operation;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<String> getStatus() {
        return Optional.ofNullable(status);
    }

    public DomainState withStatus(String status) {
        DomainState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.domainState");
        _x.status = status;
        return _x;
    }

    public DomainState withUnmappedField(String name, Object value) {
        DomainState _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime lastActionDateTime;
        private String operation;
        private String status;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder lastActionDateTime(OffsetDateTime lastActionDateTime) {
            this.lastActionDateTime = lastActionDateTime;
            this.changedFields = changedFields.add("lastActionDateTime");
            return this;
        }

        public Builder operation(String operation) {
            this.operation = operation;
            this.changedFields = changedFields.add("operation");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public DomainState build() {
            DomainState _x = new DomainState();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.domainState";
            _x.lastActionDateTime = lastActionDateTime;
            _x.operation = operation;
            _x.status = status;
            return _x;
        }
    }

    private DomainState _copy() {
        DomainState _x = new DomainState();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.lastActionDateTime = lastActionDateTime;
        _x.operation = operation;
        _x.status = status;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DomainState[");
        b.append("lastActionDateTime=");
        b.append(this.lastActionDateTime);
        b.append(", ");
        b.append("operation=");
        b.append(this.operation);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
