package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "contentName", 
    "lastModfiedBy"})
@JsonInclude(Include.NON_NULL)
public class DlpWindowsDevicesNotification extends DlpNotification implements ODataType {

    @JsonProperty("contentName")
    protected String contentName;

    @JsonProperty("lastModfiedBy")
    protected String lastModfiedBy;

    protected DlpWindowsDevicesNotification() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.dlpWindowsDevicesNotification";
    }

    @Property(name="contentName")
    @JsonIgnore
    public Optional<String> getContentName() {
        return Optional.ofNullable(contentName);
    }

    public DlpWindowsDevicesNotification withContentName(String contentName) {
        DlpWindowsDevicesNotification _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dlpWindowsDevicesNotification");
        _x.contentName = contentName;
        return _x;
    }

    @Property(name="lastModfiedBy")
    @JsonIgnore
    public Optional<String> getLastModfiedBy() {
        return Optional.ofNullable(lastModfiedBy);
    }

    public DlpWindowsDevicesNotification withLastModfiedBy(String lastModfiedBy) {
        DlpWindowsDevicesNotification _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dlpWindowsDevicesNotification");
        _x.lastModfiedBy = lastModfiedBy;
        return _x;
    }

    public DlpWindowsDevicesNotification withUnmappedField(String name, Object value) {
        DlpWindowsDevicesNotification _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDlpWindowsDevicesNotification() {
        return new Builder();
    }

    public static final class Builder {
        private String author;
        private String contentName;
        private String lastModfiedBy;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder author(String author) {
            this.author = author;
            this.changedFields = changedFields.add("author");
            return this;
        }

        public Builder contentName(String contentName) {
            this.contentName = contentName;
            this.changedFields = changedFields.add("contentName");
            return this;
        }

        public Builder lastModfiedBy(String lastModfiedBy) {
            this.lastModfiedBy = lastModfiedBy;
            this.changedFields = changedFields.add("lastModfiedBy");
            return this;
        }

        public DlpWindowsDevicesNotification build() {
            DlpWindowsDevicesNotification _x = new DlpWindowsDevicesNotification();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.dlpWindowsDevicesNotification";
            _x.author = author;
            _x.contentName = contentName;
            _x.lastModfiedBy = lastModfiedBy;
            return _x;
        }
    }

    private DlpWindowsDevicesNotification _copy() {
        DlpWindowsDevicesNotification _x = new DlpWindowsDevicesNotification();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.author = author;
        _x.contentName = contentName;
        _x.lastModfiedBy = lastModfiedBy;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DlpWindowsDevicesNotification[");
        b.append("author=");
        b.append(this.author);
        b.append(", ");
        b.append("contentName=");
        b.append(this.contentName);
        b.append(", ");
        b.append("lastModfiedBy=");
        b.append(this.lastModfiedBy);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
