package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "auditCorrelationId", 
    "evaluationDateTime", 
    "matchingRules"})
@JsonInclude(Include.NON_NULL)
public class DlpPoliciesJobResult implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("auditCorrelationId")
    protected String auditCorrelationId;

    @JsonProperty("evaluationDateTime")
    protected OffsetDateTime evaluationDateTime;

    @JsonProperty("matchingRules")
    protected List<MatchingDlpRule> matchingRules;

    @JsonProperty("matchingRules@nextLink")
    protected String matchingRulesNextLink;

    protected DlpPoliciesJobResult() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.dlpPoliciesJobResult";
    }

    @Property(name="auditCorrelationId")
    @JsonIgnore
    public Optional<String> getAuditCorrelationId() {
        return Optional.ofNullable(auditCorrelationId);
    }

    public DlpPoliciesJobResult withAuditCorrelationId(String auditCorrelationId) {
        DlpPoliciesJobResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dlpPoliciesJobResult");
        _x.auditCorrelationId = auditCorrelationId;
        return _x;
    }

    @Property(name="evaluationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEvaluationDateTime() {
        return Optional.ofNullable(evaluationDateTime);
    }

    public DlpPoliciesJobResult withEvaluationDateTime(OffsetDateTime evaluationDateTime) {
        DlpPoliciesJobResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dlpPoliciesJobResult");
        _x.evaluationDateTime = evaluationDateTime;
        return _x;
    }

    @Property(name="matchingRules")
    @JsonIgnore
    public CollectionPage<MatchingDlpRule> getMatchingRules() {
        return new CollectionPage<MatchingDlpRule>(contextPath, MatchingDlpRule.class, this.matchingRules, Optional.ofNullable(matchingRulesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="matchingRules")
    @JsonIgnore
    public CollectionPage<MatchingDlpRule> getMatchingRules(HttpRequestOptions options) {
        return new CollectionPage<MatchingDlpRule>(contextPath, MatchingDlpRule.class, this.matchingRules, Optional.ofNullable(matchingRulesNextLink), Collections.emptyList(), options);
    }

    public DlpPoliciesJobResult withUnmappedField(String name, Object value) {
        DlpPoliciesJobResult _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String auditCorrelationId;
        private OffsetDateTime evaluationDateTime;
        private List<MatchingDlpRule> matchingRules;
        private String matchingRulesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder auditCorrelationId(String auditCorrelationId) {
            this.auditCorrelationId = auditCorrelationId;
            this.changedFields = changedFields.add("auditCorrelationId");
            return this;
        }

        public Builder evaluationDateTime(OffsetDateTime evaluationDateTime) {
            this.evaluationDateTime = evaluationDateTime;
            this.changedFields = changedFields.add("evaluationDateTime");
            return this;
        }

        public Builder matchingRules(List<MatchingDlpRule> matchingRules) {
            this.matchingRules = matchingRules;
            this.changedFields = changedFields.add("matchingRules");
            return this;
        }

        public Builder matchingRules(MatchingDlpRule... matchingRules) {
            return matchingRules(Arrays.asList(matchingRules));
        }

        public Builder matchingRulesNextLink(String matchingRulesNextLink) {
            this.matchingRulesNextLink = matchingRulesNextLink;
            this.changedFields = changedFields.add("matchingRules");
            return this;
        }

        public DlpPoliciesJobResult build() {
            DlpPoliciesJobResult _x = new DlpPoliciesJobResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.dlpPoliciesJobResult";
            _x.auditCorrelationId = auditCorrelationId;
            _x.evaluationDateTime = evaluationDateTime;
            _x.matchingRules = matchingRules;
            _x.matchingRulesNextLink = matchingRulesNextLink;
            return _x;
        }
    }

    private DlpPoliciesJobResult _copy() {
        DlpPoliciesJobResult _x = new DlpPoliciesJobResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.auditCorrelationId = auditCorrelationId;
        _x.evaluationDateTime = evaluationDateTime;
        _x.matchingRules = matchingRules;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DlpPoliciesJobResult[");
        b.append("auditCorrelationId=");
        b.append(this.auditCorrelationId);
        b.append(", ");
        b.append("evaluationDateTime=");
        b.append(this.evaluationDateTime);
        b.append(", ");
        b.append("matchingRules=");
        b.append(this.matchingRules);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
