package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "evaluationInput", 
    "notificationInfo", 
    "target"})
@JsonInclude(Include.NON_NULL)
public class DlpEvaluatePoliciesRequest implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("evaluationInput")
    protected DlpEvaluationInput evaluationInput;

    @JsonProperty("notificationInfo")
    protected DlpNotification notificationInfo;

    @JsonProperty("target")
    protected String target;

    protected DlpEvaluatePoliciesRequest() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.dlpEvaluatePoliciesRequest";
    }

    @Property(name="evaluationInput")
    @JsonIgnore
    public Optional<DlpEvaluationInput> getEvaluationInput() {
        return Optional.ofNullable(evaluationInput);
    }

    public DlpEvaluatePoliciesRequest withEvaluationInput(DlpEvaluationInput evaluationInput) {
        DlpEvaluatePoliciesRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dlpEvaluatePoliciesRequest");
        _x.evaluationInput = evaluationInput;
        return _x;
    }

    @Property(name="notificationInfo")
    @JsonIgnore
    public Optional<DlpNotification> getNotificationInfo() {
        return Optional.ofNullable(notificationInfo);
    }

    public DlpEvaluatePoliciesRequest withNotificationInfo(DlpNotification notificationInfo) {
        DlpEvaluatePoliciesRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dlpEvaluatePoliciesRequest");
        _x.notificationInfo = notificationInfo;
        return _x;
    }

    @Property(name="target")
    @JsonIgnore
    public Optional<String> getTarget() {
        return Optional.ofNullable(target);
    }

    public DlpEvaluatePoliciesRequest withTarget(String target) {
        DlpEvaluatePoliciesRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dlpEvaluatePoliciesRequest");
        _x.target = target;
        return _x;
    }

    public DlpEvaluatePoliciesRequest withUnmappedField(String name, Object value) {
        DlpEvaluatePoliciesRequest _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private DlpEvaluationInput evaluationInput;
        private DlpNotification notificationInfo;
        private String target;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder evaluationInput(DlpEvaluationInput evaluationInput) {
            this.evaluationInput = evaluationInput;
            this.changedFields = changedFields.add("evaluationInput");
            return this;
        }

        public Builder notificationInfo(DlpNotification notificationInfo) {
            this.notificationInfo = notificationInfo;
            this.changedFields = changedFields.add("notificationInfo");
            return this;
        }

        public Builder target(String target) {
            this.target = target;
            this.changedFields = changedFields.add("target");
            return this;
        }

        public DlpEvaluatePoliciesRequest build() {
            DlpEvaluatePoliciesRequest _x = new DlpEvaluatePoliciesRequest();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.dlpEvaluatePoliciesRequest";
            _x.evaluationInput = evaluationInput;
            _x.notificationInfo = notificationInfo;
            _x.target = target;
            return _x;
        }
    }

    private DlpEvaluatePoliciesRequest _copy() {
        DlpEvaluatePoliciesRequest _x = new DlpEvaluatePoliciesRequest();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.evaluationInput = evaluationInput;
        _x.notificationInfo = notificationInfo;
        _x.target = target;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DlpEvaluatePoliciesRequest[");
        b.append("evaluationInput=");
        b.append(this.evaluationInput);
        b.append(", ");
        b.append("notificationInfo=");
        b.append(this.notificationInfo);
        b.append(", ");
        b.append("target=");
        b.append(this.target);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
