package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "total", 
    "used"})
@JsonInclude(Include.NON_NULL)
public class DirectorySizeQuota implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("total")
    protected Integer total;

    @JsonProperty("used")
    protected Integer used;

    protected DirectorySizeQuota() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.directorySizeQuota";
    }

    @Property(name="total")
    @JsonIgnore
    public Optional<Integer> getTotal() {
        return Optional.ofNullable(total);
    }

    public DirectorySizeQuota withTotal(Integer total) {
        DirectorySizeQuota _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.directorySizeQuota");
        _x.total = total;
        return _x;
    }

    @Property(name="used")
    @JsonIgnore
    public Optional<Integer> getUsed() {
        return Optional.ofNullable(used);
    }

    public DirectorySizeQuota withUsed(Integer used) {
        DirectorySizeQuota _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.directorySizeQuota");
        _x.used = used;
        return _x;
    }

    public DirectorySizeQuota withUnmappedField(String name, Object value) {
        DirectorySizeQuota _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer total;
        private Integer used;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder total(Integer total) {
            this.total = total;
            this.changedFields = changedFields.add("total");
            return this;
        }

        public Builder used(Integer used) {
            this.used = used;
            this.changedFields = changedFields.add("used");
            return this;
        }

        public DirectorySizeQuota build() {
            DirectorySizeQuota _x = new DirectorySizeQuota();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.directorySizeQuota";
            _x.total = total;
            _x.used = used;
            return _x;
        }
    }

    private DirectorySizeQuota _copy() {
        DirectorySizeQuota _x = new DirectorySizeQuota();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.total = total;
        _x.used = used;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DirectorySizeQuota[");
        b.append("total=");
        b.append(this.total);
        b.append(", ");
        b.append("used=");
        b.append(this.used);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
