package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DlpAction;
import odata.msgraph.client.beta.enums.RestrictionAction;
import odata.msgraph.client.beta.enums.RestrictionTrigger;

@JsonPropertyOrder({
    "@odata.type", 
    "message", 
    "restrictionAction", 
    "triggers"})
@JsonInclude(Include.NON_NULL)
public class DeviceRestrictionAction extends DlpActionInfo implements ODataType {

    @JsonProperty("message")
    protected String message;

    @JsonProperty("restrictionAction")
    protected RestrictionAction restrictionAction;

    @JsonProperty("triggers")
    protected List<RestrictionTrigger> triggers;

    @JsonProperty("triggers@nextLink")
    protected String triggersNextLink;

    protected DeviceRestrictionAction() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceRestrictionAction";
    }

    @Property(name="message")
    @JsonIgnore
    public Optional<String> getMessage() {
        return Optional.ofNullable(message);
    }

    public DeviceRestrictionAction withMessage(String message) {
        DeviceRestrictionAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceRestrictionAction");
        _x.message = message;
        return _x;
    }

    @Property(name="restrictionAction")
    @JsonIgnore
    public Optional<RestrictionAction> getRestrictionAction() {
        return Optional.ofNullable(restrictionAction);
    }

    public DeviceRestrictionAction withRestrictionAction(RestrictionAction restrictionAction) {
        DeviceRestrictionAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceRestrictionAction");
        _x.restrictionAction = restrictionAction;
        return _x;
    }

    @Property(name="triggers")
    @JsonIgnore
    public CollectionPage<RestrictionTrigger> getTriggers() {
        return new CollectionPage<RestrictionTrigger>(contextPath, RestrictionTrigger.class, this.triggers, Optional.ofNullable(triggersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="triggers")
    @JsonIgnore
    public CollectionPage<RestrictionTrigger> getTriggers(HttpRequestOptions options) {
        return new CollectionPage<RestrictionTrigger>(contextPath, RestrictionTrigger.class, this.triggers, Optional.ofNullable(triggersNextLink), Collections.emptyList(), options);
    }

    public DeviceRestrictionAction withUnmappedField(String name, Object value) {
        DeviceRestrictionAction _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceRestrictionAction() {
        return new Builder();
    }

    public static final class Builder {
        private DlpAction action;
        private String message;
        private RestrictionAction restrictionAction;
        private List<RestrictionTrigger> triggers;
        private String triggersNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder action(DlpAction action) {
            this.action = action;
            this.changedFields = changedFields.add("action");
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            this.changedFields = changedFields.add("message");
            return this;
        }

        public Builder restrictionAction(RestrictionAction restrictionAction) {
            this.restrictionAction = restrictionAction;
            this.changedFields = changedFields.add("restrictionAction");
            return this;
        }

        public Builder triggers(List<RestrictionTrigger> triggers) {
            this.triggers = triggers;
            this.changedFields = changedFields.add("triggers");
            return this;
        }

        public Builder triggers(RestrictionTrigger... triggers) {
            return triggers(Arrays.asList(triggers));
        }

        public Builder triggersNextLink(String triggersNextLink) {
            this.triggersNextLink = triggersNextLink;
            this.changedFields = changedFields.add("triggers");
            return this;
        }

        public DeviceRestrictionAction build() {
            DeviceRestrictionAction _x = new DeviceRestrictionAction();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceRestrictionAction";
            _x.action = action;
            _x.message = message;
            _x.restrictionAction = restrictionAction;
            _x.triggers = triggers;
            _x.triggersNextLink = triggersNextLink;
            return _x;
        }
    }

    private DeviceRestrictionAction _copy() {
        DeviceRestrictionAction _x = new DeviceRestrictionAction();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.action = action;
        _x.message = message;
        _x.restrictionAction = restrictionAction;
        _x.triggers = triggers;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceRestrictionAction[");
        b.append("action=");
        b.append(this.action);
        b.append(", ");
        b.append("message=");
        b.append(this.message);
        b.append(", ");
        b.append("restrictionAction=");
        b.append(this.restrictionAction);
        b.append(", ");
        b.append("triggers=");
        b.append(this.triggers);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
