package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Device operating system summary.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "androidCorporateWorkProfileCount", 
    "androidCount", 
    "androidDedicatedCount", 
    "androidDeviceAdminCount", 
    "androidFullyManagedCount", 
    "androidWorkProfileCount", 
    "aospUserAssociatedCount", 
    "aospUserlessCount", 
    "chromeOSCount", 
    "configMgrDeviceCount", 
    "iosCount", 
    "linuxCount", 
    "macOSCount", 
    "unknownCount", 
    "windowsCount", 
    "windowsMobileCount"})
@JsonInclude(Include.NON_NULL)
public class DeviceOperatingSystemSummary implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("androidCorporateWorkProfileCount")
    protected Integer androidCorporateWorkProfileCount;

    @JsonProperty("androidCount")
    protected Integer androidCount;

    @JsonProperty("androidDedicatedCount")
    protected Integer androidDedicatedCount;

    @JsonProperty("androidDeviceAdminCount")
    protected Integer androidDeviceAdminCount;

    @JsonProperty("androidFullyManagedCount")
    protected Integer androidFullyManagedCount;

    @JsonProperty("androidWorkProfileCount")
    protected Integer androidWorkProfileCount;

    @JsonProperty("aospUserAssociatedCount")
    protected Integer aospUserAssociatedCount;

    @JsonProperty("aospUserlessCount")
    protected Integer aospUserlessCount;

    @JsonProperty("chromeOSCount")
    protected Integer chromeOSCount;

    @JsonProperty("configMgrDeviceCount")
    protected Integer configMgrDeviceCount;

    @JsonProperty("iosCount")
    protected Integer iosCount;

    @JsonProperty("linuxCount")
    protected Integer linuxCount;

    @JsonProperty("macOSCount")
    protected Integer macOSCount;

    @JsonProperty("unknownCount")
    protected Integer unknownCount;

    @JsonProperty("windowsCount")
    protected Integer windowsCount;

    @JsonProperty("windowsMobileCount")
    protected Integer windowsMobileCount;

    protected DeviceOperatingSystemSummary() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceOperatingSystemSummary";
    }

    /**
     * <i>“The count of Corporate work profile Android devices. Also known as Corporate
     * Owned Personally Enabled (COPE). Valid values -1 to 2147483647”</i>
     * 
     * @return property androidCorporateWorkProfileCount
     */
    @Property(name="androidCorporateWorkProfileCount")
    @JsonIgnore
    public Optional<Integer> getAndroidCorporateWorkProfileCount() {
        return Optional.ofNullable(androidCorporateWorkProfileCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * androidCorporateWorkProfileCount} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The count of Corporate work profile Android devices. Also known as Corporate
     * Owned Personally Enabled (COPE). Valid values -1 to 2147483647”</i>
     * 
     * @param androidCorporateWorkProfileCount
     *            new value of {@code androidCorporateWorkProfileCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code androidCorporateWorkProfileCount} field changed
     */
    public DeviceOperatingSystemSummary withAndroidCorporateWorkProfileCount(Integer androidCorporateWorkProfileCount) {
        DeviceOperatingSystemSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceOperatingSystemSummary");
        _x.androidCorporateWorkProfileCount = androidCorporateWorkProfileCount;
        return _x;
    }

    /**
     * <i>“Number of android device count.”</i>
     * 
     * @return property androidCount
     */
    @Property(name="androidCount")
    @JsonIgnore
    public Optional<Integer> getAndroidCount() {
        return Optional.ofNullable(androidCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code androidCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of android device count.”</i>
     * 
     * @param androidCount
     *            new value of {@code androidCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code androidCount} field changed
     */
    public DeviceOperatingSystemSummary withAndroidCount(Integer androidCount) {
        DeviceOperatingSystemSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceOperatingSystemSummary");
        _x.androidCount = androidCount;
        return _x;
    }

    /**
     * <i>“Number of dedicated Android devices.”</i>
     * 
     * @return property androidDedicatedCount
     */
    @Property(name="androidDedicatedCount")
    @JsonIgnore
    public Optional<Integer> getAndroidDedicatedCount() {
        return Optional.ofNullable(androidDedicatedCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * androidDedicatedCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of dedicated Android devices.”</i>
     * 
     * @param androidDedicatedCount
     *            new value of {@code androidDedicatedCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code androidDedicatedCount} field changed
     */
    public DeviceOperatingSystemSummary withAndroidDedicatedCount(Integer androidDedicatedCount) {
        DeviceOperatingSystemSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceOperatingSystemSummary");
        _x.androidDedicatedCount = androidDedicatedCount;
        return _x;
    }

    /**
     * <i>“Number of device admin Android devices.”</i>
     * 
     * @return property androidDeviceAdminCount
     */
    @Property(name="androidDeviceAdminCount")
    @JsonIgnore
    public Optional<Integer> getAndroidDeviceAdminCount() {
        return Optional.ofNullable(androidDeviceAdminCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * androidDeviceAdminCount} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Number of device admin Android devices.”</i>
     * 
     * @param androidDeviceAdminCount
     *            new value of {@code androidDeviceAdminCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code androidDeviceAdminCount} field changed
     */
    public DeviceOperatingSystemSummary withAndroidDeviceAdminCount(Integer androidDeviceAdminCount) {
        DeviceOperatingSystemSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceOperatingSystemSummary");
        _x.androidDeviceAdminCount = androidDeviceAdminCount;
        return _x;
    }

    /**
     * <i>“Number of fully managed Android devices.”</i>
     * 
     * @return property androidFullyManagedCount
     */
    @Property(name="androidFullyManagedCount")
    @JsonIgnore
    public Optional<Integer> getAndroidFullyManagedCount() {
        return Optional.ofNullable(androidFullyManagedCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * androidFullyManagedCount} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Number of fully managed Android devices.”</i>
     * 
     * @param androidFullyManagedCount
     *            new value of {@code androidFullyManagedCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code androidFullyManagedCount} field changed
     */
    public DeviceOperatingSystemSummary withAndroidFullyManagedCount(Integer androidFullyManagedCount) {
        DeviceOperatingSystemSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceOperatingSystemSummary");
        _x.androidFullyManagedCount = androidFullyManagedCount;
        return _x;
    }

    /**
     * <i>“Number of work profile Android devices.”</i>
     * 
     * @return property androidWorkProfileCount
     */
    @Property(name="androidWorkProfileCount")
    @JsonIgnore
    public Optional<Integer> getAndroidWorkProfileCount() {
        return Optional.ofNullable(androidWorkProfileCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * androidWorkProfileCount} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Number of work profile Android devices.”</i>
     * 
     * @param androidWorkProfileCount
     *            new value of {@code androidWorkProfileCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code androidWorkProfileCount} field changed
     */
    public DeviceOperatingSystemSummary withAndroidWorkProfileCount(Integer androidWorkProfileCount) {
        DeviceOperatingSystemSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceOperatingSystemSummary");
        _x.androidWorkProfileCount = androidWorkProfileCount;
        return _x;
    }

    /**
     * <i>“Number of AOSP user-associated Android devices. Valid values 0 to 2147483647”</i>
     * 
     * @return property aospUserAssociatedCount
     */
    @Property(name="aospUserAssociatedCount")
    @JsonIgnore
    public Optional<Integer> getAospUserAssociatedCount() {
        return Optional.ofNullable(aospUserAssociatedCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * aospUserAssociatedCount} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Number of AOSP user-associated Android devices. Valid values 0 to 2147483647”</i>
     * 
     * @param aospUserAssociatedCount
     *            new value of {@code aospUserAssociatedCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code aospUserAssociatedCount} field changed
     */
    public DeviceOperatingSystemSummary withAospUserAssociatedCount(Integer aospUserAssociatedCount) {
        DeviceOperatingSystemSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceOperatingSystemSummary");
        _x.aospUserAssociatedCount = aospUserAssociatedCount;
        return _x;
    }

    /**
     * <i>“Number of AOSP userless Android devices. Valid values 0 to 2147483647”</i>
     * 
     * @return property aospUserlessCount
     */
    @Property(name="aospUserlessCount")
    @JsonIgnore
    public Optional<Integer> getAospUserlessCount() {
        return Optional.ofNullable(aospUserlessCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code aospUserlessCount
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of AOSP userless Android devices. Valid values 0 to 2147483647”</i>
     * 
     * @param aospUserlessCount
     *            new value of {@code aospUserlessCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code aospUserlessCount} field changed
     */
    public DeviceOperatingSystemSummary withAospUserlessCount(Integer aospUserlessCount) {
        DeviceOperatingSystemSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceOperatingSystemSummary");
        _x.aospUserlessCount = aospUserlessCount;
        return _x;
    }

    /**
     * <i>“Number of Chrome OS devices. Valid values 0 to 2147483647”</i>
     * 
     * @return property chromeOSCount
     */
    @Property(name="chromeOSCount")
    @JsonIgnore
    public Optional<Integer> getChromeOSCount() {
        return Optional.ofNullable(chromeOSCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code chromeOSCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of Chrome OS devices. Valid values 0 to 2147483647”</i>
     * 
     * @param chromeOSCount
     *            new value of {@code chromeOSCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code chromeOSCount} field changed
     */
    public DeviceOperatingSystemSummary withChromeOSCount(Integer chromeOSCount) {
        DeviceOperatingSystemSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceOperatingSystemSummary");
        _x.chromeOSCount = chromeOSCount;
        return _x;
    }

    /**
     * <i>“Number of ConfigMgr managed devices.”</i>
     * 
     * @return property configMgrDeviceCount
     */
    @Property(name="configMgrDeviceCount")
    @JsonIgnore
    public Optional<Integer> getConfigMgrDeviceCount() {
        return Optional.ofNullable(configMgrDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * configMgrDeviceCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of ConfigMgr managed devices.”</i>
     * 
     * @param configMgrDeviceCount
     *            new value of {@code configMgrDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code configMgrDeviceCount} field changed
     */
    public DeviceOperatingSystemSummary withConfigMgrDeviceCount(Integer configMgrDeviceCount) {
        DeviceOperatingSystemSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceOperatingSystemSummary");
        _x.configMgrDeviceCount = configMgrDeviceCount;
        return _x;
    }

    /**
     * <i>“Number of iOS device count.”</i>
     * 
     * @return property iosCount
     */
    @Property(name="iosCount")
    @JsonIgnore
    public Optional<Integer> getIosCount() {
        return Optional.ofNullable(iosCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code iosCount} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Number of iOS device count.”</i>
     * 
     * @param iosCount
     *            new value of {@code iosCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code iosCount} field changed
     */
    public DeviceOperatingSystemSummary withIosCount(Integer iosCount) {
        DeviceOperatingSystemSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceOperatingSystemSummary");
        _x.iosCount = iosCount;
        return _x;
    }

    /**
     * <i>“Number of Linux OS devices. Valid values 0 to 2147483647”</i>
     * 
     * @return property linuxCount
     */
    @Property(name="linuxCount")
    @JsonIgnore
    public Optional<Integer> getLinuxCount() {
        return Optional.ofNullable(linuxCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code linuxCount} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Number of Linux OS devices. Valid values 0 to 2147483647”</i>
     * 
     * @param linuxCount
     *            new value of {@code linuxCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code linuxCount} field changed
     */
    public DeviceOperatingSystemSummary withLinuxCount(Integer linuxCount) {
        DeviceOperatingSystemSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceOperatingSystemSummary");
        _x.linuxCount = linuxCount;
        return _x;
    }

    /**
     * <i>“Number of Mac OS X device count.”</i>
     * 
     * @return property macOSCount
     */
    @Property(name="macOSCount")
    @JsonIgnore
    public Optional<Integer> getMacOSCount() {
        return Optional.ofNullable(macOSCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code macOSCount} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Number of Mac OS X device count.”</i>
     * 
     * @param macOSCount
     *            new value of {@code macOSCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code macOSCount} field changed
     */
    public DeviceOperatingSystemSummary withMacOSCount(Integer macOSCount) {
        DeviceOperatingSystemSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceOperatingSystemSummary");
        _x.macOSCount = macOSCount;
        return _x;
    }

    /**
     * <i>“Number of unknown device count.”</i>
     * 
     * @return property unknownCount
     */
    @Property(name="unknownCount")
    @JsonIgnore
    public Optional<Integer> getUnknownCount() {
        return Optional.ofNullable(unknownCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code unknownCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of unknown device count.”</i>
     * 
     * @param unknownCount
     *            new value of {@code unknownCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code unknownCount} field changed
     */
    public DeviceOperatingSystemSummary withUnknownCount(Integer unknownCount) {
        DeviceOperatingSystemSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceOperatingSystemSummary");
        _x.unknownCount = unknownCount;
        return _x;
    }

    /**
     * <i>“Number of Windows device count.”</i>
     * 
     * @return property windowsCount
     */
    @Property(name="windowsCount")
    @JsonIgnore
    public Optional<Integer> getWindowsCount() {
        return Optional.ofNullable(windowsCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code windowsCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of Windows device count.”</i>
     * 
     * @param windowsCount
     *            new value of {@code windowsCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsCount} field changed
     */
    public DeviceOperatingSystemSummary withWindowsCount(Integer windowsCount) {
        DeviceOperatingSystemSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceOperatingSystemSummary");
        _x.windowsCount = windowsCount;
        return _x;
    }

    /**
     * <i>“Number of Windows mobile device count.”</i>
     * 
     * @return property windowsMobileCount
     */
    @Property(name="windowsMobileCount")
    @JsonIgnore
    public Optional<Integer> getWindowsMobileCount() {
        return Optional.ofNullable(windowsMobileCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windowsMobileCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of Windows mobile device count.”</i>
     * 
     * @param windowsMobileCount
     *            new value of {@code windowsMobileCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsMobileCount} field changed
     */
    public DeviceOperatingSystemSummary withWindowsMobileCount(Integer windowsMobileCount) {
        DeviceOperatingSystemSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceOperatingSystemSummary");
        _x.windowsMobileCount = windowsMobileCount;
        return _x;
    }

    public DeviceOperatingSystemSummary withUnmappedField(String name, Object value) {
        DeviceOperatingSystemSummary _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer androidCorporateWorkProfileCount;
        private Integer androidCount;
        private Integer androidDedicatedCount;
        private Integer androidDeviceAdminCount;
        private Integer androidFullyManagedCount;
        private Integer androidWorkProfileCount;
        private Integer aospUserAssociatedCount;
        private Integer aospUserlessCount;
        private Integer chromeOSCount;
        private Integer configMgrDeviceCount;
        private Integer iosCount;
        private Integer linuxCount;
        private Integer macOSCount;
        private Integer unknownCount;
        private Integer windowsCount;
        private Integer windowsMobileCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The count of Corporate work profile Android devices. Also known as Corporate
         * Owned Personally Enabled (COPE). Valid values -1 to 2147483647”</i>
         * 
         * @param androidCorporateWorkProfileCount
         *            value of {@code androidCorporateWorkProfileCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder androidCorporateWorkProfileCount(Integer androidCorporateWorkProfileCount) {
            this.androidCorporateWorkProfileCount = androidCorporateWorkProfileCount;
            this.changedFields = changedFields.add("androidCorporateWorkProfileCount");
            return this;
        }

        /**
         * <i>“Number of android device count.”</i>
         * 
         * @param androidCount
         *            value of {@code androidCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder androidCount(Integer androidCount) {
            this.androidCount = androidCount;
            this.changedFields = changedFields.add("androidCount");
            return this;
        }

        /**
         * <i>“Number of dedicated Android devices.”</i>
         * 
         * @param androidDedicatedCount
         *            value of {@code androidDedicatedCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder androidDedicatedCount(Integer androidDedicatedCount) {
            this.androidDedicatedCount = androidDedicatedCount;
            this.changedFields = changedFields.add("androidDedicatedCount");
            return this;
        }

        /**
         * <i>“Number of device admin Android devices.”</i>
         * 
         * @param androidDeviceAdminCount
         *            value of {@code androidDeviceAdminCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder androidDeviceAdminCount(Integer androidDeviceAdminCount) {
            this.androidDeviceAdminCount = androidDeviceAdminCount;
            this.changedFields = changedFields.add("androidDeviceAdminCount");
            return this;
        }

        /**
         * <i>“Number of fully managed Android devices.”</i>
         * 
         * @param androidFullyManagedCount
         *            value of {@code androidFullyManagedCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder androidFullyManagedCount(Integer androidFullyManagedCount) {
            this.androidFullyManagedCount = androidFullyManagedCount;
            this.changedFields = changedFields.add("androidFullyManagedCount");
            return this;
        }

        /**
         * <i>“Number of work profile Android devices.”</i>
         * 
         * @param androidWorkProfileCount
         *            value of {@code androidWorkProfileCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder androidWorkProfileCount(Integer androidWorkProfileCount) {
            this.androidWorkProfileCount = androidWorkProfileCount;
            this.changedFields = changedFields.add("androidWorkProfileCount");
            return this;
        }

        /**
         * <i>“Number of AOSP user-associated Android devices. Valid values 0 to 2147483647”</i>
         * 
         * @param aospUserAssociatedCount
         *            value of {@code aospUserAssociatedCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder aospUserAssociatedCount(Integer aospUserAssociatedCount) {
            this.aospUserAssociatedCount = aospUserAssociatedCount;
            this.changedFields = changedFields.add("aospUserAssociatedCount");
            return this;
        }

        /**
         * <i>“Number of AOSP userless Android devices. Valid values 0 to 2147483647”</i>
         * 
         * @param aospUserlessCount
         *            value of {@code aospUserlessCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder aospUserlessCount(Integer aospUserlessCount) {
            this.aospUserlessCount = aospUserlessCount;
            this.changedFields = changedFields.add("aospUserlessCount");
            return this;
        }

        /**
         * <i>“Number of Chrome OS devices. Valid values 0 to 2147483647”</i>
         * 
         * @param chromeOSCount
         *            value of {@code chromeOSCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder chromeOSCount(Integer chromeOSCount) {
            this.chromeOSCount = chromeOSCount;
            this.changedFields = changedFields.add("chromeOSCount");
            return this;
        }

        /**
         * <i>“Number of ConfigMgr managed devices.”</i>
         * 
         * @param configMgrDeviceCount
         *            value of {@code configMgrDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder configMgrDeviceCount(Integer configMgrDeviceCount) {
            this.configMgrDeviceCount = configMgrDeviceCount;
            this.changedFields = changedFields.add("configMgrDeviceCount");
            return this;
        }

        /**
         * <i>“Number of iOS device count.”</i>
         * 
         * @param iosCount
         *            value of {@code iosCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iosCount(Integer iosCount) {
            this.iosCount = iosCount;
            this.changedFields = changedFields.add("iosCount");
            return this;
        }

        /**
         * <i>“Number of Linux OS devices. Valid values 0 to 2147483647”</i>
         * 
         * @param linuxCount
         *            value of {@code linuxCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder linuxCount(Integer linuxCount) {
            this.linuxCount = linuxCount;
            this.changedFields = changedFields.add("linuxCount");
            return this;
        }

        /**
         * <i>“Number of Mac OS X device count.”</i>
         * 
         * @param macOSCount
         *            value of {@code macOSCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder macOSCount(Integer macOSCount) {
            this.macOSCount = macOSCount;
            this.changedFields = changedFields.add("macOSCount");
            return this;
        }

        /**
         * <i>“Number of unknown device count.”</i>
         * 
         * @param unknownCount
         *            value of {@code unknownCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder unknownCount(Integer unknownCount) {
            this.unknownCount = unknownCount;
            this.changedFields = changedFields.add("unknownCount");
            return this;
        }

        /**
         * <i>“Number of Windows device count.”</i>
         * 
         * @param windowsCount
         *            value of {@code windowsCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsCount(Integer windowsCount) {
            this.windowsCount = windowsCount;
            this.changedFields = changedFields.add("windowsCount");
            return this;
        }

        /**
         * <i>“Number of Windows mobile device count.”</i>
         * 
         * @param windowsMobileCount
         *            value of {@code windowsMobileCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsMobileCount(Integer windowsMobileCount) {
            this.windowsMobileCount = windowsMobileCount;
            this.changedFields = changedFields.add("windowsMobileCount");
            return this;
        }

        public DeviceOperatingSystemSummary build() {
            DeviceOperatingSystemSummary _x = new DeviceOperatingSystemSummary();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceOperatingSystemSummary";
            _x.androidCorporateWorkProfileCount = androidCorporateWorkProfileCount;
            _x.androidCount = androidCount;
            _x.androidDedicatedCount = androidDedicatedCount;
            _x.androidDeviceAdminCount = androidDeviceAdminCount;
            _x.androidFullyManagedCount = androidFullyManagedCount;
            _x.androidWorkProfileCount = androidWorkProfileCount;
            _x.aospUserAssociatedCount = aospUserAssociatedCount;
            _x.aospUserlessCount = aospUserlessCount;
            _x.chromeOSCount = chromeOSCount;
            _x.configMgrDeviceCount = configMgrDeviceCount;
            _x.iosCount = iosCount;
            _x.linuxCount = linuxCount;
            _x.macOSCount = macOSCount;
            _x.unknownCount = unknownCount;
            _x.windowsCount = windowsCount;
            _x.windowsMobileCount = windowsMobileCount;
            return _x;
        }
    }

    private DeviceOperatingSystemSummary _copy() {
        DeviceOperatingSystemSummary _x = new DeviceOperatingSystemSummary();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.androidCorporateWorkProfileCount = androidCorporateWorkProfileCount;
        _x.androidCount = androidCount;
        _x.androidDedicatedCount = androidDedicatedCount;
        _x.androidDeviceAdminCount = androidDeviceAdminCount;
        _x.androidFullyManagedCount = androidFullyManagedCount;
        _x.androidWorkProfileCount = androidWorkProfileCount;
        _x.aospUserAssociatedCount = aospUserAssociatedCount;
        _x.aospUserlessCount = aospUserlessCount;
        _x.chromeOSCount = chromeOSCount;
        _x.configMgrDeviceCount = configMgrDeviceCount;
        _x.iosCount = iosCount;
        _x.linuxCount = linuxCount;
        _x.macOSCount = macOSCount;
        _x.unknownCount = unknownCount;
        _x.windowsCount = windowsCount;
        _x.windowsMobileCount = windowsMobileCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceOperatingSystemSummary[");
        b.append("androidCorporateWorkProfileCount=");
        b.append(this.androidCorporateWorkProfileCount);
        b.append(", ");
        b.append("androidCount=");
        b.append(this.androidCount);
        b.append(", ");
        b.append("androidDedicatedCount=");
        b.append(this.androidDedicatedCount);
        b.append(", ");
        b.append("androidDeviceAdminCount=");
        b.append(this.androidDeviceAdminCount);
        b.append(", ");
        b.append("androidFullyManagedCount=");
        b.append(this.androidFullyManagedCount);
        b.append(", ");
        b.append("androidWorkProfileCount=");
        b.append(this.androidWorkProfileCount);
        b.append(", ");
        b.append("aospUserAssociatedCount=");
        b.append(this.aospUserAssociatedCount);
        b.append(", ");
        b.append("aospUserlessCount=");
        b.append(this.aospUserlessCount);
        b.append(", ");
        b.append("chromeOSCount=");
        b.append(this.chromeOSCount);
        b.append(", ");
        b.append("configMgrDeviceCount=");
        b.append(this.configMgrDeviceCount);
        b.append(", ");
        b.append("iosCount=");
        b.append(this.iosCount);
        b.append(", ");
        b.append("linuxCount=");
        b.append(this.linuxCount);
        b.append(", ");
        b.append("macOSCount=");
        b.append(this.macOSCount);
        b.append(", ");
        b.append("unknownCount=");
        b.append(this.unknownCount);
        b.append(", ");
        b.append("windowsCount=");
        b.append(this.windowsCount);
        b.append(", ");
        b.append("windowsMobileCount=");
        b.append(this.windowsMobileCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
