package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Constraint enforcing the setting matches against a given RegEx pattern”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "regex"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementSettingRegexConstraint extends DeviceManagementConstraint implements ODataType {

    @JsonProperty("regex")
    protected String regex;

    protected DeviceManagementSettingRegexConstraint() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementSettingRegexConstraint";
    }

    /**
     * <i>“The RegEx pattern to match against”</i>
     * 
     * @return property regex
     */
    @Property(name="regex")
    @JsonIgnore
    public Optional<String> getRegex() {
        return Optional.ofNullable(regex);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code regex} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The RegEx pattern to match against”</i>
     * 
     * @param regex
     *            new value of {@code regex} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code regex} field changed
     */
    public DeviceManagementSettingRegexConstraint withRegex(String regex) {
        DeviceManagementSettingRegexConstraint _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementSettingRegexConstraint");
        _x.regex = regex;
        return _x;
    }

    public DeviceManagementSettingRegexConstraint withUnmappedField(String name, Object value) {
        DeviceManagementSettingRegexConstraint _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementSettingRegexConstraint() {
        return new Builder();
    }

    public static final class Builder {
        private String regex;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The RegEx pattern to match against”</i>
         * 
         * @param regex
         *            value of {@code regex} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder regex(String regex) {
            this.regex = regex;
            this.changedFields = changedFields.add("regex");
            return this;
        }

        public DeviceManagementSettingRegexConstraint build() {
            DeviceManagementSettingRegexConstraint _x = new DeviceManagementSettingRegexConstraint();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementSettingRegexConstraint";
            _x.regex = regex;
            return _x;
        }
    }

    private DeviceManagementSettingRegexConstraint _copy() {
        DeviceManagementSettingRegexConstraint _x = new DeviceManagementSettingRegexConstraint();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.regex = regex;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementSettingRegexConstraint[");
        b.append("regex=");
        b.append(this.regex);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
