package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“Constraint enforcing a given profile metadata”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "source", 
    "types"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementSettingProfileConstraint extends DeviceManagementConstraint implements ODataType {

    @JsonProperty("source")
    protected String source;

    @JsonProperty("types")
    protected List<String> types;

    @JsonProperty("types@nextLink")
    protected String typesNextLink;

    protected DeviceManagementSettingProfileConstraint() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementSettingProfileConstraint";
    }

    /**
     * <i>“The source of the entity”</i>
     * 
     * @return property source
     */
    @Property(name="source")
    @JsonIgnore
    public Optional<String> getSource() {
        return Optional.ofNullable(source);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code source} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The source of the entity”</i>
     * 
     * @param source
     *            new value of {@code source} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code source} field changed
     */
    public DeviceManagementSettingProfileConstraint withSource(String source) {
        DeviceManagementSettingProfileConstraint _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementSettingProfileConstraint");
        _x.source = source;
        return _x;
    }

    /**
     * <i>“A collection of types this entity carries”</i>
     * 
     * @return property types
     */
    @Property(name="types")
    @JsonIgnore
    public CollectionPage<String> getTypes() {
        return new CollectionPage<String>(contextPath, String.class, this.types, Optional.ofNullable(typesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“A collection of types this entity carries”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property types
     */
    @Property(name="types")
    @JsonIgnore
    public CollectionPage<String> getTypes(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.types, Optional.ofNullable(typesNextLink), Collections.emptyList(), options);
    }

    public DeviceManagementSettingProfileConstraint withUnmappedField(String name, Object value) {
        DeviceManagementSettingProfileConstraint _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementSettingProfileConstraint() {
        return new Builder();
    }

    public static final class Builder {
        private String source;
        private List<String> types;
        private String typesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The source of the entity”</i>
         * 
         * @param source
         *            value of {@code source} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder source(String source) {
            this.source = source;
            this.changedFields = changedFields.add("source");
            return this;
        }

        /**
         * <i>“A collection of types this entity carries”</i>
         * 
         * @param types
         *            value of {@code types} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder types(List<String> types) {
            this.types = types;
            this.changedFields = changedFields.add("types");
            return this;
        }

        /**
         * <i>“A collection of types this entity carries”</i>
         * 
         * @param types
         *            value of {@code types} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder types(String... types) {
            return types(Arrays.asList(types));
        }

        /**
         * <i>“A collection of types this entity carries”</i>
         * 
         * @param typesNextLink
         *            value of {@code types@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder typesNextLink(String typesNextLink) {
            this.typesNextLink = typesNextLink;
            this.changedFields = changedFields.add("types");
            return this;
        }

        public DeviceManagementSettingProfileConstraint build() {
            DeviceManagementSettingProfileConstraint _x = new DeviceManagementSettingProfileConstraint();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementSettingProfileConstraint";
            _x.source = source;
            _x.types = types;
            _x.typesNextLink = typesNextLink;
            return _x;
        }
    }

    private DeviceManagementSettingProfileConstraint _copy() {
        DeviceManagementSettingProfileConstraint _x = new DeviceManagementSettingProfileConstraint();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.source = source;
        _x.types = types;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementSettingProfileConstraint[");
        b.append("source=");
        b.append(this.source);
        b.append(", ");
        b.append("types=");
        b.append(this.types);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
