package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DeviceManagementComparisonResult;


/**
 * <i>“Entity representing setting comparison result”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "comparisonResult", 
    "currentValueJson", 
    "definitionId", 
    "displayName", 
    "id", 
    "newValueJson"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementSettingComparison implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("comparisonResult")
    protected DeviceManagementComparisonResult comparisonResult;

    @JsonProperty("currentValueJson")
    protected String currentValueJson;

    @JsonProperty("definitionId")
    protected String definitionId;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("id")
    protected String id;

    @JsonProperty("newValueJson")
    protected String newValueJson;

    protected DeviceManagementSettingComparison() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementSettingComparison";
    }

    /**
     * <i>“Setting comparison result”</i>
     * 
     * @return property comparisonResult
     */
    @Property(name="comparisonResult")
    @JsonIgnore
    public Optional<DeviceManagementComparisonResult> getComparisonResult() {
        return Optional.ofNullable(comparisonResult);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code comparisonResult}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Setting comparison result”</i>
     * 
     * @param comparisonResult
     *            new value of {@code comparisonResult} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code comparisonResult} field changed
     */
    public DeviceManagementSettingComparison withComparisonResult(DeviceManagementComparisonResult comparisonResult) {
        DeviceManagementSettingComparison _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementSettingComparison");
        _x.comparisonResult = comparisonResult;
        return _x;
    }

    /**
     * <i>“JSON representation of current intent (or) template setting's value”</i>
     * 
     * @return property currentValueJson
     */
    @Property(name="currentValueJson")
    @JsonIgnore
    public Optional<String> getCurrentValueJson() {
        return Optional.ofNullable(currentValueJson);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code currentValueJson}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“JSON representation of current intent (or) template setting's value”</i>
     * 
     * @param currentValueJson
     *            new value of {@code currentValueJson} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code currentValueJson} field changed
     */
    public DeviceManagementSettingComparison withCurrentValueJson(String currentValueJson) {
        DeviceManagementSettingComparison _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementSettingComparison");
        _x.currentValueJson = currentValueJson;
        return _x;
    }

    /**
     * <i>“The ID of the setting definition for this instance”</i>
     * 
     * @return property definitionId
     */
    @Property(name="definitionId")
    @JsonIgnore
    public Optional<String> getDefinitionId() {
        return Optional.ofNullable(definitionId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code definitionId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The ID of the setting definition for this instance”</i>
     * 
     * @param definitionId
     *            new value of {@code definitionId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code definitionId} field changed
     */
    public DeviceManagementSettingComparison withDefinitionId(String definitionId) {
        DeviceManagementSettingComparison _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementSettingComparison");
        _x.definitionId = definitionId;
        return _x;
    }

    /**
     * <i>“The setting's display name”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The setting's display name”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public DeviceManagementSettingComparison withDisplayName(String displayName) {
        DeviceManagementSettingComparison _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementSettingComparison");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“The setting ID”</i>
     * 
     * @return property id
     */
    @Property(name="id")
    @JsonIgnore
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code id} field changed
     * . Field description below. The field name is also added to an internal map of
     * changed fields in the returned object so that when {@code this.patch()} is
     * called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The setting ID”</i>
     * 
     * @param id
     *            new value of {@code id} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code id} field changed
     */
    public DeviceManagementSettingComparison withId(String id) {
        DeviceManagementSettingComparison _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementSettingComparison");
        _x.id = id;
        return _x;
    }

    /**
     * <i>“JSON representation of new template setting's value”</i>
     * 
     * @return property newValueJson
     */
    @Property(name="newValueJson")
    @JsonIgnore
    public Optional<String> getNewValueJson() {
        return Optional.ofNullable(newValueJson);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code newValueJson}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“JSON representation of new template setting's value”</i>
     * 
     * @param newValueJson
     *            new value of {@code newValueJson} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code newValueJson} field changed
     */
    public DeviceManagementSettingComparison withNewValueJson(String newValueJson) {
        DeviceManagementSettingComparison _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementSettingComparison");
        _x.newValueJson = newValueJson;
        return _x;
    }

    public DeviceManagementSettingComparison withUnmappedField(String name, Object value) {
        DeviceManagementSettingComparison _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private DeviceManagementComparisonResult comparisonResult;
        private String currentValueJson;
        private String definitionId;
        private String displayName;
        private String id;
        private String newValueJson;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Setting comparison result”</i>
         * 
         * @param comparisonResult
         *            value of {@code comparisonResult} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder comparisonResult(DeviceManagementComparisonResult comparisonResult) {
            this.comparisonResult = comparisonResult;
            this.changedFields = changedFields.add("comparisonResult");
            return this;
        }

        /**
         * <i>“JSON representation of current intent (or) template setting's value”</i>
         * 
         * @param currentValueJson
         *            value of {@code currentValueJson} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder currentValueJson(String currentValueJson) {
            this.currentValueJson = currentValueJson;
            this.changedFields = changedFields.add("currentValueJson");
            return this;
        }

        /**
         * <i>“The ID of the setting definition for this instance”</i>
         * 
         * @param definitionId
         *            value of {@code definitionId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder definitionId(String definitionId) {
            this.definitionId = definitionId;
            this.changedFields = changedFields.add("definitionId");
            return this;
        }

        /**
         * <i>“The setting's display name”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“The setting ID”</i>
         * 
         * @param id
         *            value of {@code id} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“JSON representation of new template setting's value”</i>
         * 
         * @param newValueJson
         *            value of {@code newValueJson} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder newValueJson(String newValueJson) {
            this.newValueJson = newValueJson;
            this.changedFields = changedFields.add("newValueJson");
            return this;
        }

        public DeviceManagementSettingComparison build() {
            DeviceManagementSettingComparison _x = new DeviceManagementSettingComparison();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementSettingComparison";
            _x.comparisonResult = comparisonResult;
            _x.currentValueJson = currentValueJson;
            _x.definitionId = definitionId;
            _x.displayName = displayName;
            _x.id = id;
            _x.newValueJson = newValueJson;
            return _x;
        }
    }

    private DeviceManagementSettingComparison _copy() {
        DeviceManagementSettingComparison _x = new DeviceManagementSettingComparison();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.comparisonResult = comparisonResult;
        _x.currentValueJson = currentValueJson;
        _x.definitionId = definitionId;
        _x.displayName = displayName;
        _x.id = id;
        _x.newValueJson = newValueJson;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementSettingComparison[");
        b.append("comparisonResult=");
        b.append(this.comparisonResult);
        b.append(", ");
        b.append("currentValueJson=");
        b.append(this.currentValueJson);
        b.append(", ");
        b.append("definitionId=");
        b.append(this.definitionId);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("newValueJson=");
        b.append(this.newValueJson);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
