package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DeviceManagementExchangeAccessRuleType;


/**
 * <i>“Device Class in Exchange.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "name", 
    "type"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementExchangeDeviceClass implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("type")
    protected DeviceManagementExchangeAccessRuleType type;

    protected DeviceManagementExchangeDeviceClass() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementExchangeDeviceClass";
    }

    /**
     * <i>“Name of the device class which will be impacted by this rule.”</i>
     * 
     * @return property name
     */
    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code name} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Name of the device class which will be impacted by this rule.”</i>
     * 
     * @param name
     *            new value of {@code name} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code name} field changed
     */
    public DeviceManagementExchangeDeviceClass withName(String name) {
        DeviceManagementExchangeDeviceClass _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementExchangeDeviceClass");
        _x.name = name;
        return _x;
    }

    /**
     * <i>“Type of device which is impacted by this rule e.g. Model, Family”</i>
     * 
     * @return property type
     */
    @Property(name="type")
    @JsonIgnore
    public Optional<DeviceManagementExchangeAccessRuleType> getType() {
        return Optional.ofNullable(type);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code type} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Type of device which is impacted by this rule e.g. Model, Family”</i>
     * 
     * @param type
     *            new value of {@code type} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code type} field changed
     */
    public DeviceManagementExchangeDeviceClass withType(DeviceManagementExchangeAccessRuleType type) {
        DeviceManagementExchangeDeviceClass _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementExchangeDeviceClass");
        _x.type = type;
        return _x;
    }

    public DeviceManagementExchangeDeviceClass withUnmappedField(String name, Object value) {
        DeviceManagementExchangeDeviceClass _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private DeviceManagementExchangeAccessRuleType type;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Name of the device class which will be impacted by this rule.”</i>
         * 
         * @param name
         *            value of {@code name} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        /**
         * <i>“Type of device which is impacted by this rule e.g. Model, Family”</i>
         * 
         * @param type
         *            value of {@code type} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder type(DeviceManagementExchangeAccessRuleType type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public DeviceManagementExchangeDeviceClass build() {
            DeviceManagementExchangeDeviceClass _x = new DeviceManagementExchangeDeviceClass();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementExchangeDeviceClass";
            _x.name = name;
            _x.type = type;
            return _x;
        }
    }

    private DeviceManagementExchangeDeviceClass _copy() {
        DeviceManagementExchangeDeviceClass _x = new DeviceManagementExchangeDeviceClass();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.name = name;
        _x.type = type;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementExchangeDeviceClass[");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
