package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DeviceManagementConfigurationAzureAdTrustType;
import odata.msgraph.client.beta.enums.DeviceManagementConfigurationDeviceMode;
import odata.msgraph.client.beta.enums.DeviceManagementConfigurationPlatforms;
import odata.msgraph.client.beta.enums.DeviceManagementConfigurationTechnologies;
import odata.msgraph.client.beta.enums.DeviceManagementConfigurationWindowsSkus;

@JsonPropertyOrder({
    "@odata.type", 
    "configurationServiceProviderVersion", 
    "maximumSupportedVersion", 
    "minimumSupportedVersion", 
    "requiredAzureAdTrustType", 
    "requiresAzureAd", 
    "windowsSkus"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationWindowsSettingApplicability extends DeviceManagementConfigurationSettingApplicability implements ODataType {

    @JsonProperty("configurationServiceProviderVersion")
    protected String configurationServiceProviderVersion;

    @JsonProperty("maximumSupportedVersion")
    protected String maximumSupportedVersion;

    @JsonProperty("minimumSupportedVersion")
    protected String minimumSupportedVersion;

    @JsonProperty("requiredAzureAdTrustType")
    protected DeviceManagementConfigurationAzureAdTrustType requiredAzureAdTrustType;

    @JsonProperty("requiresAzureAd")
    protected Boolean requiresAzureAd;

    @JsonProperty("windowsSkus")
    protected List<DeviceManagementConfigurationWindowsSkus> windowsSkus;

    @JsonProperty("windowsSkus@nextLink")
    protected String windowsSkusNextLink;

    protected DeviceManagementConfigurationWindowsSettingApplicability() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationWindowsSettingApplicability";
    }

    /**
     * <i>“Version of CSP setting is a part of”</i>
     * 
     * @return property configurationServiceProviderVersion
     */
    @Property(name="configurationServiceProviderVersion")
    @JsonIgnore
    public Optional<String> getConfigurationServiceProviderVersion() {
        return Optional.ofNullable(configurationServiceProviderVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * configurationServiceProviderVersion} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Version of CSP setting is a part of”</i>
     * 
     * @param configurationServiceProviderVersion
     *            new value of {@code configurationServiceProviderVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code configurationServiceProviderVersion} field changed
     */
    public DeviceManagementConfigurationWindowsSettingApplicability withConfigurationServiceProviderVersion(String configurationServiceProviderVersion) {
        DeviceManagementConfigurationWindowsSettingApplicability _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationWindowsSettingApplicability");
        _x.configurationServiceProviderVersion = configurationServiceProviderVersion;
        return _x;
    }

    /**
     * <i>“Maximum supported version of Windows”</i>
     * 
     * @return property maximumSupportedVersion
     */
    @Property(name="maximumSupportedVersion")
    @JsonIgnore
    public Optional<String> getMaximumSupportedVersion() {
        return Optional.ofNullable(maximumSupportedVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * maximumSupportedVersion} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Maximum supported version of Windows”</i>
     * 
     * @param maximumSupportedVersion
     *            new value of {@code maximumSupportedVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code maximumSupportedVersion} field changed
     */
    public DeviceManagementConfigurationWindowsSettingApplicability withMaximumSupportedVersion(String maximumSupportedVersion) {
        DeviceManagementConfigurationWindowsSettingApplicability _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationWindowsSettingApplicability");
        _x.maximumSupportedVersion = maximumSupportedVersion;
        return _x;
    }

    /**
     * <i>“Minimum supported version of Windows”</i>
     * 
     * @return property minimumSupportedVersion
     */
    @Property(name="minimumSupportedVersion")
    @JsonIgnore
    public Optional<String> getMinimumSupportedVersion() {
        return Optional.ofNullable(minimumSupportedVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minimumSupportedVersion} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Minimum supported version of Windows”</i>
     * 
     * @param minimumSupportedVersion
     *            new value of {@code minimumSupportedVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumSupportedVersion} field changed
     */
    public DeviceManagementConfigurationWindowsSettingApplicability withMinimumSupportedVersion(String minimumSupportedVersion) {
        DeviceManagementConfigurationWindowsSettingApplicability _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationWindowsSettingApplicability");
        _x.minimumSupportedVersion = minimumSupportedVersion;
        return _x;
    }

    /**
     * <i>“Required AzureAD trust type”</i>
     * 
     * @return property requiredAzureAdTrustType
     */
    @Property(name="requiredAzureAdTrustType")
    @JsonIgnore
    public Optional<DeviceManagementConfigurationAzureAdTrustType> getRequiredAzureAdTrustType() {
        return Optional.ofNullable(requiredAzureAdTrustType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * requiredAzureAdTrustType} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Required AzureAD trust type”</i>
     * 
     * @param requiredAzureAdTrustType
     *            new value of {@code requiredAzureAdTrustType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code requiredAzureAdTrustType} field changed
     */
    public DeviceManagementConfigurationWindowsSettingApplicability withRequiredAzureAdTrustType(DeviceManagementConfigurationAzureAdTrustType requiredAzureAdTrustType) {
        DeviceManagementConfigurationWindowsSettingApplicability _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationWindowsSettingApplicability");
        _x.requiredAzureAdTrustType = requiredAzureAdTrustType;
        return _x;
    }

    /**
     * <i>“AzureAD setting requirement”</i>
     * 
     * @return property requiresAzureAd
     */
    @Property(name="requiresAzureAd")
    @JsonIgnore
    public Optional<Boolean> getRequiresAzureAd() {
        return Optional.ofNullable(requiresAzureAd);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code requiresAzureAd}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“AzureAD setting requirement”</i>
     * 
     * @param requiresAzureAd
     *            new value of {@code requiresAzureAd} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code requiresAzureAd} field changed
     */
    public DeviceManagementConfigurationWindowsSettingApplicability withRequiresAzureAd(Boolean requiresAzureAd) {
        DeviceManagementConfigurationWindowsSettingApplicability _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationWindowsSettingApplicability");
        _x.requiresAzureAd = requiresAzureAd;
        return _x;
    }

    /**
     * <i>“List of Windows SKUs that the setting is applicable for”</i>
     * 
     * @return property windowsSkus
     */
    @Property(name="windowsSkus")
    @JsonIgnore
    public CollectionPage<DeviceManagementConfigurationWindowsSkus> getWindowsSkus() {
        return new CollectionPage<DeviceManagementConfigurationWindowsSkus>(contextPath, DeviceManagementConfigurationWindowsSkus.class, this.windowsSkus, Optional.ofNullable(windowsSkusNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of Windows SKUs that the setting is applicable for”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property windowsSkus
     */
    @Property(name="windowsSkus")
    @JsonIgnore
    public CollectionPage<DeviceManagementConfigurationWindowsSkus> getWindowsSkus(HttpRequestOptions options) {
        return new CollectionPage<DeviceManagementConfigurationWindowsSkus>(contextPath, DeviceManagementConfigurationWindowsSkus.class, this.windowsSkus, Optional.ofNullable(windowsSkusNextLink), Collections.emptyList(), options);
    }

    public DeviceManagementConfigurationWindowsSettingApplicability withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationWindowsSettingApplicability _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementConfigurationWindowsSettingApplicability() {
        return new Builder();
    }

    public static final class Builder {
        private String description;
        private DeviceManagementConfigurationDeviceMode deviceMode;
        private DeviceManagementConfigurationPlatforms platform;
        private DeviceManagementConfigurationTechnologies technologies;
        private String configurationServiceProviderVersion;
        private String maximumSupportedVersion;
        private String minimumSupportedVersion;
        private DeviceManagementConfigurationAzureAdTrustType requiredAzureAdTrustType;
        private Boolean requiresAzureAd;
        private List<DeviceManagementConfigurationWindowsSkus> windowsSkus;
        private String windowsSkusNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder deviceMode(DeviceManagementConfigurationDeviceMode deviceMode) {
            this.deviceMode = deviceMode;
            this.changedFields = changedFields.add("deviceMode");
            return this;
        }

        public Builder platform(DeviceManagementConfigurationPlatforms platform) {
            this.platform = platform;
            this.changedFields = changedFields.add("platform");
            return this;
        }

        public Builder technologies(DeviceManagementConfigurationTechnologies technologies) {
            this.technologies = technologies;
            this.changedFields = changedFields.add("technologies");
            return this;
        }

        /**
         * <i>“Version of CSP setting is a part of”</i>
         * 
         * @param configurationServiceProviderVersion
         *            value of {@code configurationServiceProviderVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder configurationServiceProviderVersion(String configurationServiceProviderVersion) {
            this.configurationServiceProviderVersion = configurationServiceProviderVersion;
            this.changedFields = changedFields.add("configurationServiceProviderVersion");
            return this;
        }

        /**
         * <i>“Maximum supported version of Windows”</i>
         * 
         * @param maximumSupportedVersion
         *            value of {@code maximumSupportedVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder maximumSupportedVersion(String maximumSupportedVersion) {
            this.maximumSupportedVersion = maximumSupportedVersion;
            this.changedFields = changedFields.add("maximumSupportedVersion");
            return this;
        }

        /**
         * <i>“Minimum supported version of Windows”</i>
         * 
         * @param minimumSupportedVersion
         *            value of {@code minimumSupportedVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumSupportedVersion(String minimumSupportedVersion) {
            this.minimumSupportedVersion = minimumSupportedVersion;
            this.changedFields = changedFields.add("minimumSupportedVersion");
            return this;
        }

        /**
         * <i>“Required AzureAD trust type”</i>
         * 
         * @param requiredAzureAdTrustType
         *            value of {@code requiredAzureAdTrustType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder requiredAzureAdTrustType(DeviceManagementConfigurationAzureAdTrustType requiredAzureAdTrustType) {
            this.requiredAzureAdTrustType = requiredAzureAdTrustType;
            this.changedFields = changedFields.add("requiredAzureAdTrustType");
            return this;
        }

        /**
         * <i>“AzureAD setting requirement”</i>
         * 
         * @param requiresAzureAd
         *            value of {@code requiresAzureAd} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder requiresAzureAd(Boolean requiresAzureAd) {
            this.requiresAzureAd = requiresAzureAd;
            this.changedFields = changedFields.add("requiresAzureAd");
            return this;
        }

        /**
         * <i>“List of Windows SKUs that the setting is applicable for”</i>
         * 
         * @param windowsSkus
         *            value of {@code windowsSkus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsSkus(List<DeviceManagementConfigurationWindowsSkus> windowsSkus) {
            this.windowsSkus = windowsSkus;
            this.changedFields = changedFields.add("windowsSkus");
            return this;
        }

        /**
         * <i>“List of Windows SKUs that the setting is applicable for”</i>
         * 
         * @param windowsSkus
         *            value of {@code windowsSkus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsSkus(DeviceManagementConfigurationWindowsSkus... windowsSkus) {
            return windowsSkus(Arrays.asList(windowsSkus));
        }

        /**
         * <i>“List of Windows SKUs that the setting is applicable for”</i>
         * 
         * @param windowsSkusNextLink
         *            value of {@code windowsSkus@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsSkusNextLink(String windowsSkusNextLink) {
            this.windowsSkusNextLink = windowsSkusNextLink;
            this.changedFields = changedFields.add("windowsSkus");
            return this;
        }

        public DeviceManagementConfigurationWindowsSettingApplicability build() {
            DeviceManagementConfigurationWindowsSettingApplicability _x = new DeviceManagementConfigurationWindowsSettingApplicability();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementConfigurationWindowsSettingApplicability";
            _x.description = description;
            _x.deviceMode = deviceMode;
            _x.platform = platform;
            _x.technologies = technologies;
            _x.configurationServiceProviderVersion = configurationServiceProviderVersion;
            _x.maximumSupportedVersion = maximumSupportedVersion;
            _x.minimumSupportedVersion = minimumSupportedVersion;
            _x.requiredAzureAdTrustType = requiredAzureAdTrustType;
            _x.requiresAzureAd = requiresAzureAd;
            _x.windowsSkus = windowsSkus;
            _x.windowsSkusNextLink = windowsSkusNextLink;
            return _x;
        }
    }

    private DeviceManagementConfigurationWindowsSettingApplicability _copy() {
        DeviceManagementConfigurationWindowsSettingApplicability _x = new DeviceManagementConfigurationWindowsSettingApplicability();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.description = description;
        _x.deviceMode = deviceMode;
        _x.platform = platform;
        _x.technologies = technologies;
        _x.configurationServiceProviderVersion = configurationServiceProviderVersion;
        _x.maximumSupportedVersion = maximumSupportedVersion;
        _x.minimumSupportedVersion = minimumSupportedVersion;
        _x.requiredAzureAdTrustType = requiredAzureAdTrustType;
        _x.requiresAzureAd = requiresAzureAd;
        _x.windowsSkus = windowsSkus;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationWindowsSettingApplicability[");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("deviceMode=");
        b.append(this.deviceMode);
        b.append(", ");
        b.append("platform=");
        b.append(this.platform);
        b.append(", ");
        b.append("technologies=");
        b.append(this.technologies);
        b.append(", ");
        b.append("configurationServiceProviderVersion=");
        b.append(this.configurationServiceProviderVersion);
        b.append(", ");
        b.append("maximumSupportedVersion=");
        b.append(this.maximumSupportedVersion);
        b.append(", ");
        b.append("minimumSupportedVersion=");
        b.append(this.minimumSupportedVersion);
        b.append(", ");
        b.append("requiredAzureAdTrustType=");
        b.append(this.requiredAzureAdTrustType);
        b.append(", ");
        b.append("requiresAzureAd=");
        b.append(this.requiresAzureAd);
        b.append(", ");
        b.append("windowsSkus=");
        b.append(this.windowsSkus);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
