package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“String Setting Value Template”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "defaultValue"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationStringSettingValueTemplate extends DeviceManagementConfigurationSimpleSettingValueTemplate implements ODataType {

    @JsonProperty("defaultValue")
    protected DeviceManagementConfigurationStringSettingValueDefaultTemplate defaultValue;

    protected DeviceManagementConfigurationStringSettingValueTemplate() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationStringSettingValueTemplate";
    }

    /**
     * <i>“String Setting Value Default Template.”</i>
     * 
     * @return property defaultValue
     */
    @Property(name="defaultValue")
    @JsonIgnore
    public Optional<DeviceManagementConfigurationStringSettingValueDefaultTemplate> getDefaultValue() {
        return Optional.ofNullable(defaultValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code defaultValue}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“String Setting Value Default Template.”</i>
     * 
     * @param defaultValue
     *            new value of {@code defaultValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defaultValue} field changed
     */
    public DeviceManagementConfigurationStringSettingValueTemplate withDefaultValue(DeviceManagementConfigurationStringSettingValueDefaultTemplate defaultValue) {
        DeviceManagementConfigurationStringSettingValueTemplate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationStringSettingValueTemplate");
        _x.defaultValue = defaultValue;
        return _x;
    }

    public DeviceManagementConfigurationStringSettingValueTemplate withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationStringSettingValueTemplate _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementConfigurationStringSettingValueTemplate() {
        return new Builder();
    }

    public static final class Builder {
        private String settingValueTemplateId;
        private DeviceManagementConfigurationStringSettingValueDefaultTemplate defaultValue;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder settingValueTemplateId(String settingValueTemplateId) {
            this.settingValueTemplateId = settingValueTemplateId;
            this.changedFields = changedFields.add("settingValueTemplateId");
            return this;
        }

        /**
         * <i>“String Setting Value Default Template.”</i>
         * 
         * @param defaultValue
         *            value of {@code defaultValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defaultValue(DeviceManagementConfigurationStringSettingValueDefaultTemplate defaultValue) {
            this.defaultValue = defaultValue;
            this.changedFields = changedFields.add("defaultValue");
            return this;
        }

        public DeviceManagementConfigurationStringSettingValueTemplate build() {
            DeviceManagementConfigurationStringSettingValueTemplate _x = new DeviceManagementConfigurationStringSettingValueTemplate();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementConfigurationStringSettingValueTemplate";
            _x.settingValueTemplateId = settingValueTemplateId;
            _x.defaultValue = defaultValue;
            return _x;
        }
    }

    private DeviceManagementConfigurationStringSettingValueTemplate _copy() {
        DeviceManagementConfigurationStringSettingValueTemplate _x = new DeviceManagementConfigurationStringSettingValueTemplate();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.settingValueTemplateId = settingValueTemplateId;
        _x.defaultValue = defaultValue;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationStringSettingValueTemplate[");
        b.append("settingValueTemplateId=");
        b.append(this.settingValueTemplateId);
        b.append(", ");
        b.append("defaultValue=");
        b.append(this.defaultValue);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
