package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Simple Setting Value Template”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "settingValueTemplateId"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationSimpleSettingValueTemplate implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("settingValueTemplateId")
    protected String settingValueTemplateId;

    protected DeviceManagementConfigurationSimpleSettingValueTemplate() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationSimpleSettingValueTemplate";
    }

    /**
     * <i>“Setting Value Template Id”</i>
     * 
     * @return property settingValueTemplateId
     */
    @Property(name="settingValueTemplateId")
    @JsonIgnore
    public Optional<String> getSettingValueTemplateId() {
        return Optional.ofNullable(settingValueTemplateId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * settingValueTemplateId} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Setting Value Template Id”</i>
     * 
     * @param settingValueTemplateId
     *            new value of {@code settingValueTemplateId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingValueTemplateId} field changed
     */
    public DeviceManagementConfigurationSimpleSettingValueTemplate withSettingValueTemplateId(String settingValueTemplateId) {
        DeviceManagementConfigurationSimpleSettingValueTemplate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationSimpleSettingValueTemplate");
        _x.settingValueTemplateId = settingValueTemplateId;
        return _x;
    }

    public DeviceManagementConfigurationSimpleSettingValueTemplate withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationSimpleSettingValueTemplate _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    private DeviceManagementConfigurationSimpleSettingValueTemplate _copy() {
        DeviceManagementConfigurationSimpleSettingValueTemplate _x = new DeviceManagementConfigurationSimpleSettingValueTemplate();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.settingValueTemplateId = settingValueTemplateId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationSimpleSettingValueTemplate[");
        b.append("settingValueTemplateId=");
        b.append(this.settingValueTemplateId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
