package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;


/**
 * <i>“Simple setting value”</i>
 */@JsonPropertyOrder({
    "@odata.type"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationSimpleSettingValue extends DeviceManagementConfigurationSettingValue implements ODataType {

    protected DeviceManagementConfigurationSimpleSettingValue() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationSimpleSettingValue";
    }

    public DeviceManagementConfigurationSimpleSettingValue withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationSimpleSettingValue _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    private DeviceManagementConfigurationSimpleSettingValue _copy() {
        DeviceManagementConfigurationSimpleSettingValue _x = new DeviceManagementConfigurationSimpleSettingValue();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.settingValueTemplateReference = settingValueTemplateReference;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationSimpleSettingValue[");
        b.append("settingValueTemplateReference=");
        b.append(this.settingValueTemplateReference);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
