package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "maxDeviceOccurrence", 
    "minDeviceOccurrence"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationSettingOccurrence implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("maxDeviceOccurrence")
    protected Integer maxDeviceOccurrence;

    @JsonProperty("minDeviceOccurrence")
    protected Integer minDeviceOccurrence;

    protected DeviceManagementConfigurationSettingOccurrence() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationSettingOccurrence";
    }

    /**
     * <i>“Maximum times setting can be set on device.”</i>
     * 
     * @return property maxDeviceOccurrence
     */
    @Property(name="maxDeviceOccurrence")
    @JsonIgnore
    public Optional<Integer> getMaxDeviceOccurrence() {
        return Optional.ofNullable(maxDeviceOccurrence);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * maxDeviceOccurrence} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Maximum times setting can be set on device.”</i>
     * 
     * @param maxDeviceOccurrence
     *            new value of {@code maxDeviceOccurrence} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code maxDeviceOccurrence} field changed
     */
    public DeviceManagementConfigurationSettingOccurrence withMaxDeviceOccurrence(Integer maxDeviceOccurrence) {
        DeviceManagementConfigurationSettingOccurrence _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationSettingOccurrence");
        _x.maxDeviceOccurrence = maxDeviceOccurrence;
        return _x;
    }

    /**
     * <i>“Minimum times setting can be set on device. A MinDeviceOccurrence of 0 means
     * setting is optional”</i>
     * 
     * @return property minDeviceOccurrence
     */
    @Property(name="minDeviceOccurrence")
    @JsonIgnore
    public Optional<Integer> getMinDeviceOccurrence() {
        return Optional.ofNullable(minDeviceOccurrence);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minDeviceOccurrence} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Minimum times setting can be set on device. A MinDeviceOccurrence of 0 means
     * setting is optional”</i>
     * 
     * @param minDeviceOccurrence
     *            new value of {@code minDeviceOccurrence} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minDeviceOccurrence} field changed
     */
    public DeviceManagementConfigurationSettingOccurrence withMinDeviceOccurrence(Integer minDeviceOccurrence) {
        DeviceManagementConfigurationSettingOccurrence _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationSettingOccurrence");
        _x.minDeviceOccurrence = minDeviceOccurrence;
        return _x;
    }

    public DeviceManagementConfigurationSettingOccurrence withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationSettingOccurrence _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer maxDeviceOccurrence;
        private Integer minDeviceOccurrence;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Maximum times setting can be set on device.”</i>
         * 
         * @param maxDeviceOccurrence
         *            value of {@code maxDeviceOccurrence} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder maxDeviceOccurrence(Integer maxDeviceOccurrence) {
            this.maxDeviceOccurrence = maxDeviceOccurrence;
            this.changedFields = changedFields.add("maxDeviceOccurrence");
            return this;
        }

        /**
         * <i>“Minimum times setting can be set on device. A MinDeviceOccurrence of 0 means
         * setting is optional”</i>
         * 
         * @param minDeviceOccurrence
         *            value of {@code minDeviceOccurrence} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minDeviceOccurrence(Integer minDeviceOccurrence) {
            this.minDeviceOccurrence = minDeviceOccurrence;
            this.changedFields = changedFields.add("minDeviceOccurrence");
            return this;
        }

        public DeviceManagementConfigurationSettingOccurrence build() {
            DeviceManagementConfigurationSettingOccurrence _x = new DeviceManagementConfigurationSettingOccurrence();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementConfigurationSettingOccurrence";
            _x.maxDeviceOccurrence = maxDeviceOccurrence;
            _x.minDeviceOccurrence = minDeviceOccurrence;
            return _x;
        }
    }

    private DeviceManagementConfigurationSettingOccurrence _copy() {
        DeviceManagementConfigurationSettingOccurrence _x = new DeviceManagementConfigurationSettingOccurrence();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.maxDeviceOccurrence = maxDeviceOccurrence;
        _x.minDeviceOccurrence = minDeviceOccurrence;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationSettingOccurrence[");
        b.append("maxDeviceOccurrence=");
        b.append(this.maxDeviceOccurrence);
        b.append(", ");
        b.append("minDeviceOccurrence=");
        b.append(this.minDeviceOccurrence);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
