package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Setting Instance Template”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "isRequired", 
    "settingDefinitionId", 
    "settingInstanceTemplateId"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationSettingInstanceTemplate implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("isRequired")
    protected Boolean isRequired;

    @JsonProperty("settingDefinitionId")
    protected String settingDefinitionId;

    @JsonProperty("settingInstanceTemplateId")
    protected String settingInstanceTemplateId;

    protected DeviceManagementConfigurationSettingInstanceTemplate() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationSettingInstanceTemplate";
    }

    /**
     * <i>“Indicates if a policy must specify this setting.”</i>
     * 
     * @return property isRequired
     */
    @Property(name="isRequired")
    @JsonIgnore
    public Optional<Boolean> getIsRequired() {
        return Optional.ofNullable(isRequired);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isRequired} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Indicates if a policy must specify this setting.”</i>
     * 
     * @param isRequired
     *            new value of {@code isRequired} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isRequired} field changed
     */
    public DeviceManagementConfigurationSettingInstanceTemplate withIsRequired(Boolean isRequired) {
        DeviceManagementConfigurationSettingInstanceTemplate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationSettingInstanceTemplate");
        _x.isRequired = isRequired;
        return _x;
    }

    /**
     * <i>“Setting Definition Id”</i>
     * 
     * @return property settingDefinitionId
     */
    @Property(name="settingDefinitionId")
    @JsonIgnore
    public Optional<String> getSettingDefinitionId() {
        return Optional.ofNullable(settingDefinitionId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * settingDefinitionId} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Setting Definition Id”</i>
     * 
     * @param settingDefinitionId
     *            new value of {@code settingDefinitionId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingDefinitionId} field changed
     */
    public DeviceManagementConfigurationSettingInstanceTemplate withSettingDefinitionId(String settingDefinitionId) {
        DeviceManagementConfigurationSettingInstanceTemplate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationSettingInstanceTemplate");
        _x.settingDefinitionId = settingDefinitionId;
        return _x;
    }

    /**
     * <i>“Setting Instance Template Id”</i>
     * 
     * @return property settingInstanceTemplateId
     */
    @Property(name="settingInstanceTemplateId")
    @JsonIgnore
    public Optional<String> getSettingInstanceTemplateId() {
        return Optional.ofNullable(settingInstanceTemplateId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * settingInstanceTemplateId} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Setting Instance Template Id”</i>
     * 
     * @param settingInstanceTemplateId
     *            new value of {@code settingInstanceTemplateId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingInstanceTemplateId} field changed
     */
    public DeviceManagementConfigurationSettingInstanceTemplate withSettingInstanceTemplateId(String settingInstanceTemplateId) {
        DeviceManagementConfigurationSettingInstanceTemplate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationSettingInstanceTemplate");
        _x.settingInstanceTemplateId = settingInstanceTemplateId;
        return _x;
    }

    public DeviceManagementConfigurationSettingInstanceTemplate withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationSettingInstanceTemplate _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    private DeviceManagementConfigurationSettingInstanceTemplate _copy() {
        DeviceManagementConfigurationSettingInstanceTemplate _x = new DeviceManagementConfigurationSettingInstanceTemplate();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.isRequired = isRequired;
        _x.settingDefinitionId = settingDefinitionId;
        _x.settingInstanceTemplateId = settingInstanceTemplateId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationSettingInstanceTemplate[");
        b.append("isRequired=");
        b.append(this.isRequired);
        b.append(", ");
        b.append("settingDefinitionId=");
        b.append(this.settingDefinitionId);
        b.append(", ");
        b.append("settingInstanceTemplateId=");
        b.append(this.settingInstanceTemplateId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
