package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Referred setting information about reusable setting”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "settingDefinitionId"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationReferredSettingInformation implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("settingDefinitionId")
    protected String settingDefinitionId;

    protected DeviceManagementConfigurationReferredSettingInformation() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationReferredSettingInformation";
    }

    /**
     * <i>“Setting definition id that is being referred to a setting. Applicable for
     * reusable setting”</i>
     * 
     * @return property settingDefinitionId
     */
    @Property(name="settingDefinitionId")
    @JsonIgnore
    public Optional<String> getSettingDefinitionId() {
        return Optional.ofNullable(settingDefinitionId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * settingDefinitionId} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Setting definition id that is being referred to a setting. Applicable for
     * reusable setting”</i>
     * 
     * @param settingDefinitionId
     *            new value of {@code settingDefinitionId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingDefinitionId} field changed
     */
    public DeviceManagementConfigurationReferredSettingInformation withSettingDefinitionId(String settingDefinitionId) {
        DeviceManagementConfigurationReferredSettingInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationReferredSettingInformation");
        _x.settingDefinitionId = settingDefinitionId;
        return _x;
    }

    public DeviceManagementConfigurationReferredSettingInformation withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationReferredSettingInformation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String settingDefinitionId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Setting definition id that is being referred to a setting. Applicable for
         * reusable setting”</i>
         * 
         * @param settingDefinitionId
         *            value of {@code settingDefinitionId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingDefinitionId(String settingDefinitionId) {
            this.settingDefinitionId = settingDefinitionId;
            this.changedFields = changedFields.add("settingDefinitionId");
            return this;
        }

        public DeviceManagementConfigurationReferredSettingInformation build() {
            DeviceManagementConfigurationReferredSettingInformation _x = new DeviceManagementConfigurationReferredSettingInformation();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementConfigurationReferredSettingInformation";
            _x.settingDefinitionId = settingDefinitionId;
            return _x;
        }
    }

    private DeviceManagementConfigurationReferredSettingInformation _copy() {
        DeviceManagementConfigurationReferredSettingInformation _x = new DeviceManagementConfigurationReferredSettingInformation();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.settingDefinitionId = settingDefinitionId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationReferredSettingInformation[");
        b.append("settingDefinitionId=");
        b.append(this.settingDefinitionId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
