package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DeviceManagementConfigurationTemplateFamily;


/**
 * <i>“Policy template reference information”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "templateDisplayName", 
    "templateDisplayVersion", 
    "templateFamily", 
    "templateId"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationPolicyTemplateReference implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("templateDisplayName")
    protected String templateDisplayName;

    @JsonProperty("templateDisplayVersion")
    protected String templateDisplayVersion;

    @JsonProperty("templateFamily")
    protected DeviceManagementConfigurationTemplateFamily templateFamily;

    @JsonProperty("templateId")
    protected String templateId;

    protected DeviceManagementConfigurationPolicyTemplateReference() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationPolicyTemplateReference";
    }

    /**
     * <i>“Template Display Name of the referenced template. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property templateDisplayName
     */
    @Property(name="templateDisplayName")
    @JsonIgnore
    public Optional<String> getTemplateDisplayName() {
        return Optional.ofNullable(templateDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * templateDisplayName} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Template Display Name of the referenced template. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param templateDisplayName
     *            new value of {@code templateDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code templateDisplayName} field changed
     */
    public DeviceManagementConfigurationPolicyTemplateReference withTemplateDisplayName(String templateDisplayName) {
        DeviceManagementConfigurationPolicyTemplateReference _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationPolicyTemplateReference");
        _x.templateDisplayName = templateDisplayName;
        return _x;
    }

    /**
     * <i>“Template Display Version of the referenced Template. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property templateDisplayVersion
     */
    @Property(name="templateDisplayVersion")
    @JsonIgnore
    public Optional<String> getTemplateDisplayVersion() {
        return Optional.ofNullable(templateDisplayVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * templateDisplayVersion} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Template Display Version of the referenced Template. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param templateDisplayVersion
     *            new value of {@code templateDisplayVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code templateDisplayVersion} field changed
     */
    public DeviceManagementConfigurationPolicyTemplateReference withTemplateDisplayVersion(String templateDisplayVersion) {
        DeviceManagementConfigurationPolicyTemplateReference _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationPolicyTemplateReference");
        _x.templateDisplayVersion = templateDisplayVersion;
        return _x;
    }

    /**
     * <i>“Template Family of the referenced Template. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property templateFamily
     */
    @Property(name="templateFamily")
    @JsonIgnore
    public Optional<DeviceManagementConfigurationTemplateFamily> getTemplateFamily() {
        return Optional.ofNullable(templateFamily);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code templateFamily}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Template Family of the referenced Template. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param templateFamily
     *            new value of {@code templateFamily} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code templateFamily} field changed
     */
    public DeviceManagementConfigurationPolicyTemplateReference withTemplateFamily(DeviceManagementConfigurationTemplateFamily templateFamily) {
        DeviceManagementConfigurationPolicyTemplateReference _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationPolicyTemplateReference");
        _x.templateFamily = templateFamily;
        return _x;
    }

    /**
     * <i>“Template id”</i>
     * 
     * @return property templateId
     */
    @Property(name="templateId")
    @JsonIgnore
    public Optional<String> getTemplateId() {
        return Optional.ofNullable(templateId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code templateId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Template id”</i>
     * 
     * @param templateId
     *            new value of {@code templateId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code templateId} field changed
     */
    public DeviceManagementConfigurationPolicyTemplateReference withTemplateId(String templateId) {
        DeviceManagementConfigurationPolicyTemplateReference _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationPolicyTemplateReference");
        _x.templateId = templateId;
        return _x;
    }

    public DeviceManagementConfigurationPolicyTemplateReference withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationPolicyTemplateReference _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String templateDisplayName;
        private String templateDisplayVersion;
        private DeviceManagementConfigurationTemplateFamily templateFamily;
        private String templateId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Template Display Name of the referenced template. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param templateDisplayName
         *            value of {@code templateDisplayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder templateDisplayName(String templateDisplayName) {
            this.templateDisplayName = templateDisplayName;
            this.changedFields = changedFields.add("templateDisplayName");
            return this;
        }

        /**
         * <i>“Template Display Version of the referenced Template. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param templateDisplayVersion
         *            value of {@code templateDisplayVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder templateDisplayVersion(String templateDisplayVersion) {
            this.templateDisplayVersion = templateDisplayVersion;
            this.changedFields = changedFields.add("templateDisplayVersion");
            return this;
        }

        /**
         * <i>“Template Family of the referenced Template. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param templateFamily
         *            value of {@code templateFamily} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder templateFamily(DeviceManagementConfigurationTemplateFamily templateFamily) {
            this.templateFamily = templateFamily;
            this.changedFields = changedFields.add("templateFamily");
            return this;
        }

        /**
         * <i>“Template id”</i>
         * 
         * @param templateId
         *            value of {@code templateId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder templateId(String templateId) {
            this.templateId = templateId;
            this.changedFields = changedFields.add("templateId");
            return this;
        }

        public DeviceManagementConfigurationPolicyTemplateReference build() {
            DeviceManagementConfigurationPolicyTemplateReference _x = new DeviceManagementConfigurationPolicyTemplateReference();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementConfigurationPolicyTemplateReference";
            _x.templateDisplayName = templateDisplayName;
            _x.templateDisplayVersion = templateDisplayVersion;
            _x.templateFamily = templateFamily;
            _x.templateId = templateId;
            return _x;
        }
    }

    private DeviceManagementConfigurationPolicyTemplateReference _copy() {
        DeviceManagementConfigurationPolicyTemplateReference _x = new DeviceManagementConfigurationPolicyTemplateReference();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.templateDisplayName = templateDisplayName;
        _x.templateDisplayVersion = templateDisplayVersion;
        _x.templateFamily = templateFamily;
        _x.templateId = templateId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationPolicyTemplateReference[");
        b.append("templateDisplayName=");
        b.append(this.templateDisplayName);
        b.append(", ");
        b.append("templateDisplayVersion=");
        b.append(this.templateDisplayVersion);
        b.append(", ");
        b.append("templateFamily=");
        b.append(this.templateFamily);
        b.append(", ");
        b.append("templateId=");
        b.append(this.templateId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
