package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“Option Definition Template”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "children", 
    "itemId"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationOptionDefinitionTemplate implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("children")
    protected List<DeviceManagementConfigurationSettingInstanceTemplate> children;

    @JsonProperty("children@nextLink")
    protected String childrenNextLink;

    @JsonProperty("itemId")
    protected String itemId;

    protected DeviceManagementConfigurationOptionDefinitionTemplate() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationOptionDefinitionTemplate";
    }

    /**
     * <i>“Option Children”</i>
     * 
     * @return property children
     */
    @Property(name="children")
    @JsonIgnore
    public CollectionPage<DeviceManagementConfigurationSettingInstanceTemplate> getChildren() {
        return new CollectionPage<DeviceManagementConfigurationSettingInstanceTemplate>(contextPath, DeviceManagementConfigurationSettingInstanceTemplate.class, this.children, Optional.ofNullable(childrenNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Option Children”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property children
     */
    @Property(name="children")
    @JsonIgnore
    public CollectionPage<DeviceManagementConfigurationSettingInstanceTemplate> getChildren(HttpRequestOptions options) {
        return new CollectionPage<DeviceManagementConfigurationSettingInstanceTemplate>(contextPath, DeviceManagementConfigurationSettingInstanceTemplate.class, this.children, Optional.ofNullable(childrenNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Option ItemId”</i>
     * 
     * @return property itemId
     */
    @Property(name="itemId")
    @JsonIgnore
    public Optional<String> getItemId() {
        return Optional.ofNullable(itemId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code itemId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Option ItemId”</i>
     * 
     * @param itemId
     *            new value of {@code itemId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code itemId} field changed
     */
    public DeviceManagementConfigurationOptionDefinitionTemplate withItemId(String itemId) {
        DeviceManagementConfigurationOptionDefinitionTemplate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationOptionDefinitionTemplate");
        _x.itemId = itemId;
        return _x;
    }

    public DeviceManagementConfigurationOptionDefinitionTemplate withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationOptionDefinitionTemplate _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<DeviceManagementConfigurationSettingInstanceTemplate> children;
        private String childrenNextLink;
        private String itemId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Option Children”</i>
         * 
         * @param children
         *            value of {@code children} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder children(List<DeviceManagementConfigurationSettingInstanceTemplate> children) {
            this.children = children;
            this.changedFields = changedFields.add("children");
            return this;
        }

        /**
         * <i>“Option Children”</i>
         * 
         * @param children
         *            value of {@code children} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder children(DeviceManagementConfigurationSettingInstanceTemplate... children) {
            return children(Arrays.asList(children));
        }

        /**
         * <i>“Option Children”</i>
         * 
         * @param childrenNextLink
         *            value of {@code children@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder childrenNextLink(String childrenNextLink) {
            this.childrenNextLink = childrenNextLink;
            this.changedFields = changedFields.add("children");
            return this;
        }

        /**
         * <i>“Option ItemId”</i>
         * 
         * @param itemId
         *            value of {@code itemId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder itemId(String itemId) {
            this.itemId = itemId;
            this.changedFields = changedFields.add("itemId");
            return this;
        }

        public DeviceManagementConfigurationOptionDefinitionTemplate build() {
            DeviceManagementConfigurationOptionDefinitionTemplate _x = new DeviceManagementConfigurationOptionDefinitionTemplate();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementConfigurationOptionDefinitionTemplate";
            _x.children = children;
            _x.childrenNextLink = childrenNextLink;
            _x.itemId = itemId;
            return _x;
        }
    }

    private DeviceManagementConfigurationOptionDefinitionTemplate _copy() {
        DeviceManagementConfigurationOptionDefinitionTemplate _x = new DeviceManagementConfigurationOptionDefinitionTemplate();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.children = children;
        _x.itemId = itemId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationOptionDefinitionTemplate[");
        b.append("children=");
        b.append(this.children);
        b.append(", ");
        b.append("itemId=");
        b.append(this.itemId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
