package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "dependedOnBy", 
    "dependentOn", 
    "description", 
    "displayName", 
    "helpText", 
    "itemId", 
    "name", 
    "optionValue"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationOptionDefinition implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("dependedOnBy")
    protected List<DeviceManagementConfigurationSettingDependedOnBy> dependedOnBy;

    @JsonProperty("dependedOnBy@nextLink")
    protected String dependedOnByNextLink;

    @JsonProperty("dependentOn")
    protected List<DeviceManagementConfigurationDependentOn> dependentOn;

    @JsonProperty("dependentOn@nextLink")
    protected String dependentOnNextLink;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("helpText")
    protected String helpText;

    @JsonProperty("itemId")
    protected String itemId;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("optionValue")
    protected DeviceManagementConfigurationSettingValue optionValue;

    protected DeviceManagementConfigurationOptionDefinition() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationOptionDefinition";
    }

    /**
     * <i>“List of Settings that depends on this option”</i>
     * 
     * @return property dependedOnBy
     */
    @Property(name="dependedOnBy")
    @JsonIgnore
    public CollectionPage<DeviceManagementConfigurationSettingDependedOnBy> getDependedOnBy() {
        return new CollectionPage<DeviceManagementConfigurationSettingDependedOnBy>(contextPath, DeviceManagementConfigurationSettingDependedOnBy.class, this.dependedOnBy, Optional.ofNullable(dependedOnByNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of Settings that depends on this option”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property dependedOnBy
     */
    @Property(name="dependedOnBy")
    @JsonIgnore
    public CollectionPage<DeviceManagementConfigurationSettingDependedOnBy> getDependedOnBy(HttpRequestOptions options) {
        return new CollectionPage<DeviceManagementConfigurationSettingDependedOnBy>(contextPath, DeviceManagementConfigurationSettingDependedOnBy.class, this.dependedOnBy, Optional.ofNullable(dependedOnByNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“List of dependent settings for this option”</i>
     * 
     * @return property dependentOn
     */
    @Property(name="dependentOn")
    @JsonIgnore
    public CollectionPage<DeviceManagementConfigurationDependentOn> getDependentOn() {
        return new CollectionPage<DeviceManagementConfigurationDependentOn>(contextPath, DeviceManagementConfigurationDependentOn.class, this.dependentOn, Optional.ofNullable(dependentOnNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of dependent settings for this option”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property dependentOn
     */
    @Property(name="dependentOn")
    @JsonIgnore
    public CollectionPage<DeviceManagementConfigurationDependentOn> getDependentOn(HttpRequestOptions options) {
        return new CollectionPage<DeviceManagementConfigurationDependentOn>(contextPath, DeviceManagementConfigurationDependentOn.class, this.dependentOn, Optional.ofNullable(dependentOnNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Description of the option”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Description of the option”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public DeviceManagementConfigurationOptionDefinition withDescription(String description) {
        DeviceManagementConfigurationOptionDefinition _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationOptionDefinition");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“Friendly name of the option”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Friendly name of the option”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public DeviceManagementConfigurationOptionDefinition withDisplayName(String displayName) {
        DeviceManagementConfigurationOptionDefinition _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationOptionDefinition");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Help text of the option”</i>
     * 
     * @return property helpText
     */
    @Property(name="helpText")
    @JsonIgnore
    public Optional<String> getHelpText() {
        return Optional.ofNullable(helpText);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code helpText} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Help text of the option”</i>
     * 
     * @param helpText
     *            new value of {@code helpText} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code helpText} field changed
     */
    public DeviceManagementConfigurationOptionDefinition withHelpText(String helpText) {
        DeviceManagementConfigurationOptionDefinition _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationOptionDefinition");
        _x.helpText = helpText;
        return _x;
    }

    /**
     * <i>“Identifier of option”</i>
     * 
     * @return property itemId
     */
    @Property(name="itemId")
    @JsonIgnore
    public Optional<String> getItemId() {
        return Optional.ofNullable(itemId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code itemId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Identifier of option”</i>
     * 
     * @param itemId
     *            new value of {@code itemId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code itemId} field changed
     */
    public DeviceManagementConfigurationOptionDefinition withItemId(String itemId) {
        DeviceManagementConfigurationOptionDefinition _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationOptionDefinition");
        _x.itemId = itemId;
        return _x;
    }

    /**
     * <i>“Name of the option”</i>
     * 
     * @return property name
     */
    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code name} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Name of the option”</i>
     * 
     * @param name
     *            new value of {@code name} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code name} field changed
     */
    public DeviceManagementConfigurationOptionDefinition withName(String name) {
        DeviceManagementConfigurationOptionDefinition _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationOptionDefinition");
        _x.name = name;
        return _x;
    }

    /**
     * <i>“Value of the option”</i>
     * 
     * @return property optionValue
     */
    @Property(name="optionValue")
    @JsonIgnore
    public Optional<DeviceManagementConfigurationSettingValue> getOptionValue() {
        return Optional.ofNullable(optionValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code optionValue}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Value of the option”</i>
     * 
     * @param optionValue
     *            new value of {@code optionValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code optionValue} field changed
     */
    public DeviceManagementConfigurationOptionDefinition withOptionValue(DeviceManagementConfigurationSettingValue optionValue) {
        DeviceManagementConfigurationOptionDefinition _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationOptionDefinition");
        _x.optionValue = optionValue;
        return _x;
    }

    public DeviceManagementConfigurationOptionDefinition withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationOptionDefinition _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<DeviceManagementConfigurationSettingDependedOnBy> dependedOnBy;
        private String dependedOnByNextLink;
        private List<DeviceManagementConfigurationDependentOn> dependentOn;
        private String dependentOnNextLink;
        private String description;
        private String displayName;
        private String helpText;
        private String itemId;
        private String name;
        private DeviceManagementConfigurationSettingValue optionValue;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“List of Settings that depends on this option”</i>
         * 
         * @param dependedOnBy
         *            value of {@code dependedOnBy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dependedOnBy(List<DeviceManagementConfigurationSettingDependedOnBy> dependedOnBy) {
            this.dependedOnBy = dependedOnBy;
            this.changedFields = changedFields.add("dependedOnBy");
            return this;
        }

        /**
         * <i>“List of Settings that depends on this option”</i>
         * 
         * @param dependedOnBy
         *            value of {@code dependedOnBy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dependedOnBy(DeviceManagementConfigurationSettingDependedOnBy... dependedOnBy) {
            return dependedOnBy(Arrays.asList(dependedOnBy));
        }

        /**
         * <i>“List of Settings that depends on this option”</i>
         * 
         * @param dependedOnByNextLink
         *            value of {@code dependedOnBy@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dependedOnByNextLink(String dependedOnByNextLink) {
            this.dependedOnByNextLink = dependedOnByNextLink;
            this.changedFields = changedFields.add("dependedOnBy");
            return this;
        }

        /**
         * <i>“List of dependent settings for this option”</i>
         * 
         * @param dependentOn
         *            value of {@code dependentOn} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dependentOn(List<DeviceManagementConfigurationDependentOn> dependentOn) {
            this.dependentOn = dependentOn;
            this.changedFields = changedFields.add("dependentOn");
            return this;
        }

        /**
         * <i>“List of dependent settings for this option”</i>
         * 
         * @param dependentOn
         *            value of {@code dependentOn} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dependentOn(DeviceManagementConfigurationDependentOn... dependentOn) {
            return dependentOn(Arrays.asList(dependentOn));
        }

        /**
         * <i>“List of dependent settings for this option”</i>
         * 
         * @param dependentOnNextLink
         *            value of {@code dependentOn@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dependentOnNextLink(String dependentOnNextLink) {
            this.dependentOnNextLink = dependentOnNextLink;
            this.changedFields = changedFields.add("dependentOn");
            return this;
        }

        /**
         * <i>“Description of the option”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“Friendly name of the option”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Help text of the option”</i>
         * 
         * @param helpText
         *            value of {@code helpText} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder helpText(String helpText) {
            this.helpText = helpText;
            this.changedFields = changedFields.add("helpText");
            return this;
        }

        /**
         * <i>“Identifier of option”</i>
         * 
         * @param itemId
         *            value of {@code itemId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder itemId(String itemId) {
            this.itemId = itemId;
            this.changedFields = changedFields.add("itemId");
            return this;
        }

        /**
         * <i>“Name of the option”</i>
         * 
         * @param name
         *            value of {@code name} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        /**
         * <i>“Value of the option”</i>
         * 
         * @param optionValue
         *            value of {@code optionValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder optionValue(DeviceManagementConfigurationSettingValue optionValue) {
            this.optionValue = optionValue;
            this.changedFields = changedFields.add("optionValue");
            return this;
        }

        public DeviceManagementConfigurationOptionDefinition build() {
            DeviceManagementConfigurationOptionDefinition _x = new DeviceManagementConfigurationOptionDefinition();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementConfigurationOptionDefinition";
            _x.dependedOnBy = dependedOnBy;
            _x.dependedOnByNextLink = dependedOnByNextLink;
            _x.dependentOn = dependentOn;
            _x.dependentOnNextLink = dependentOnNextLink;
            _x.description = description;
            _x.displayName = displayName;
            _x.helpText = helpText;
            _x.itemId = itemId;
            _x.name = name;
            _x.optionValue = optionValue;
            return _x;
        }
    }

    private DeviceManagementConfigurationOptionDefinition _copy() {
        DeviceManagementConfigurationOptionDefinition _x = new DeviceManagementConfigurationOptionDefinition();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.dependedOnBy = dependedOnBy;
        _x.dependentOn = dependentOn;
        _x.description = description;
        _x.displayName = displayName;
        _x.helpText = helpText;
        _x.itemId = itemId;
        _x.name = name;
        _x.optionValue = optionValue;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationOptionDefinition[");
        b.append("dependedOnBy=");
        b.append(this.dependedOnBy);
        b.append(", ");
        b.append("dependentOn=");
        b.append(this.dependentOn);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("helpText=");
        b.append(this.helpText);
        b.append(", ");
        b.append("itemId=");
        b.append(this.itemId);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("optionValue=");
        b.append(this.optionValue);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
