package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Integer Setting Value Template”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "defaultValue", 
    "recommendedValueDefinition", 
    "requiredValueDefinition"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationIntegerSettingValueTemplate extends DeviceManagementConfigurationSimpleSettingValueTemplate implements ODataType {

    @JsonProperty("defaultValue")
    protected DeviceManagementConfigurationIntegerSettingValueDefaultTemplate defaultValue;

    @JsonProperty("recommendedValueDefinition")
    protected DeviceManagementConfigurationIntegerSettingValueDefinitionTemplate recommendedValueDefinition;

    @JsonProperty("requiredValueDefinition")
    protected DeviceManagementConfigurationIntegerSettingValueDefinitionTemplate requiredValueDefinition;

    protected DeviceManagementConfigurationIntegerSettingValueTemplate() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationIntegerSettingValueTemplate";
    }

    /**
     * <i>“Integer Setting Value Default Template.”</i>
     * 
     * @return property defaultValue
     */
    @Property(name="defaultValue")
    @JsonIgnore
    public Optional<DeviceManagementConfigurationIntegerSettingValueDefaultTemplate> getDefaultValue() {
        return Optional.ofNullable(defaultValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code defaultValue}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Integer Setting Value Default Template.”</i>
     * 
     * @param defaultValue
     *            new value of {@code defaultValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defaultValue} field changed
     */
    public DeviceManagementConfigurationIntegerSettingValueTemplate withDefaultValue(DeviceManagementConfigurationIntegerSettingValueDefaultTemplate defaultValue) {
        DeviceManagementConfigurationIntegerSettingValueTemplate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationIntegerSettingValueTemplate");
        _x.defaultValue = defaultValue;
        return _x;
    }

    /**
     * <i>“Recommended value definition.”</i>
     * 
     * @return property recommendedValueDefinition
     */
    @Property(name="recommendedValueDefinition")
    @JsonIgnore
    public Optional<DeviceManagementConfigurationIntegerSettingValueDefinitionTemplate> getRecommendedValueDefinition() {
        return Optional.ofNullable(recommendedValueDefinition);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * recommendedValueDefinition} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Recommended value definition.”</i>
     * 
     * @param recommendedValueDefinition
     *            new value of {@code recommendedValueDefinition} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code recommendedValueDefinition} field changed
     */
    public DeviceManagementConfigurationIntegerSettingValueTemplate withRecommendedValueDefinition(DeviceManagementConfigurationIntegerSettingValueDefinitionTemplate recommendedValueDefinition) {
        DeviceManagementConfigurationIntegerSettingValueTemplate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationIntegerSettingValueTemplate");
        _x.recommendedValueDefinition = recommendedValueDefinition;
        return _x;
    }

    /**
     * <i>“Required value definition.”</i>
     * 
     * @return property requiredValueDefinition
     */
    @Property(name="requiredValueDefinition")
    @JsonIgnore
    public Optional<DeviceManagementConfigurationIntegerSettingValueDefinitionTemplate> getRequiredValueDefinition() {
        return Optional.ofNullable(requiredValueDefinition);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * requiredValueDefinition} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Required value definition.”</i>
     * 
     * @param requiredValueDefinition
     *            new value of {@code requiredValueDefinition} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code requiredValueDefinition} field changed
     */
    public DeviceManagementConfigurationIntegerSettingValueTemplate withRequiredValueDefinition(DeviceManagementConfigurationIntegerSettingValueDefinitionTemplate requiredValueDefinition) {
        DeviceManagementConfigurationIntegerSettingValueTemplate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationIntegerSettingValueTemplate");
        _x.requiredValueDefinition = requiredValueDefinition;
        return _x;
    }

    public DeviceManagementConfigurationIntegerSettingValueTemplate withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationIntegerSettingValueTemplate _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementConfigurationIntegerSettingValueTemplate() {
        return new Builder();
    }

    public static final class Builder {
        private String settingValueTemplateId;
        private DeviceManagementConfigurationIntegerSettingValueDefaultTemplate defaultValue;
        private DeviceManagementConfigurationIntegerSettingValueDefinitionTemplate recommendedValueDefinition;
        private DeviceManagementConfigurationIntegerSettingValueDefinitionTemplate requiredValueDefinition;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder settingValueTemplateId(String settingValueTemplateId) {
            this.settingValueTemplateId = settingValueTemplateId;
            this.changedFields = changedFields.add("settingValueTemplateId");
            return this;
        }

        /**
         * <i>“Integer Setting Value Default Template.”</i>
         * 
         * @param defaultValue
         *            value of {@code defaultValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defaultValue(DeviceManagementConfigurationIntegerSettingValueDefaultTemplate defaultValue) {
            this.defaultValue = defaultValue;
            this.changedFields = changedFields.add("defaultValue");
            return this;
        }

        /**
         * <i>“Recommended value definition.”</i>
         * 
         * @param recommendedValueDefinition
         *            value of {@code recommendedValueDefinition} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder recommendedValueDefinition(DeviceManagementConfigurationIntegerSettingValueDefinitionTemplate recommendedValueDefinition) {
            this.recommendedValueDefinition = recommendedValueDefinition;
            this.changedFields = changedFields.add("recommendedValueDefinition");
            return this;
        }

        /**
         * <i>“Required value definition.”</i>
         * 
         * @param requiredValueDefinition
         *            value of {@code requiredValueDefinition} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder requiredValueDefinition(DeviceManagementConfigurationIntegerSettingValueDefinitionTemplate requiredValueDefinition) {
            this.requiredValueDefinition = requiredValueDefinition;
            this.changedFields = changedFields.add("requiredValueDefinition");
            return this;
        }

        public DeviceManagementConfigurationIntegerSettingValueTemplate build() {
            DeviceManagementConfigurationIntegerSettingValueTemplate _x = new DeviceManagementConfigurationIntegerSettingValueTemplate();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementConfigurationIntegerSettingValueTemplate";
            _x.settingValueTemplateId = settingValueTemplateId;
            _x.defaultValue = defaultValue;
            _x.recommendedValueDefinition = recommendedValueDefinition;
            _x.requiredValueDefinition = requiredValueDefinition;
            return _x;
        }
    }

    private DeviceManagementConfigurationIntegerSettingValueTemplate _copy() {
        DeviceManagementConfigurationIntegerSettingValueTemplate _x = new DeviceManagementConfigurationIntegerSettingValueTemplate();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.settingValueTemplateId = settingValueTemplateId;
        _x.defaultValue = defaultValue;
        _x.recommendedValueDefinition = recommendedValueDefinition;
        _x.requiredValueDefinition = requiredValueDefinition;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationIntegerSettingValueTemplate[");
        b.append("settingValueTemplateId=");
        b.append(this.settingValueTemplateId);
        b.append(", ");
        b.append("defaultValue=");
        b.append(this.defaultValue);
        b.append(", ");
        b.append("recommendedValueDefinition=");
        b.append(this.recommendedValueDefinition);
        b.append(", ");
        b.append("requiredValueDefinition=");
        b.append(this.requiredValueDefinition);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
