package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Integer Setting Value Definition Template”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "maxValue", 
    "minValue"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationIntegerSettingValueDefinitionTemplate implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("maxValue")
    protected Integer maxValue;

    @JsonProperty("minValue")
    protected Integer minValue;

    protected DeviceManagementConfigurationIntegerSettingValueDefinitionTemplate() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationIntegerSettingValueDefinitionTemplate";
    }

    /**
     * <i>“Integer Setting Maximum Value. Valid values -2147483648 to 2147483647”</i>
     * 
     * @return property maxValue
     */
    @Property(name="maxValue")
    @JsonIgnore
    public Optional<Integer> getMaxValue() {
        return Optional.ofNullable(maxValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code maxValue} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Integer Setting Maximum Value. Valid values -2147483648 to 2147483647”</i>
     * 
     * @param maxValue
     *            new value of {@code maxValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code maxValue} field changed
     */
    public DeviceManagementConfigurationIntegerSettingValueDefinitionTemplate withMaxValue(Integer maxValue) {
        DeviceManagementConfigurationIntegerSettingValueDefinitionTemplate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationIntegerSettingValueDefinitionTemplate");
        _x.maxValue = maxValue;
        return _x;
    }

    /**
     * <i>“Integer Setting Minimum Value. Valid values -2147483648 to 2147483647”</i>
     * 
     * @return property minValue
     */
    @Property(name="minValue")
    @JsonIgnore
    public Optional<Integer> getMinValue() {
        return Optional.ofNullable(minValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code minValue} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Integer Setting Minimum Value. Valid values -2147483648 to 2147483647”</i>
     * 
     * @param minValue
     *            new value of {@code minValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minValue} field changed
     */
    public DeviceManagementConfigurationIntegerSettingValueDefinitionTemplate withMinValue(Integer minValue) {
        DeviceManagementConfigurationIntegerSettingValueDefinitionTemplate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationIntegerSettingValueDefinitionTemplate");
        _x.minValue = minValue;
        return _x;
    }

    public DeviceManagementConfigurationIntegerSettingValueDefinitionTemplate withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationIntegerSettingValueDefinitionTemplate _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer maxValue;
        private Integer minValue;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Integer Setting Maximum Value. Valid values -2147483648 to 2147483647”</i>
         * 
         * @param maxValue
         *            value of {@code maxValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder maxValue(Integer maxValue) {
            this.maxValue = maxValue;
            this.changedFields = changedFields.add("maxValue");
            return this;
        }

        /**
         * <i>“Integer Setting Minimum Value. Valid values -2147483648 to 2147483647”</i>
         * 
         * @param minValue
         *            value of {@code minValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minValue(Integer minValue) {
            this.minValue = minValue;
            this.changedFields = changedFields.add("minValue");
            return this;
        }

        public DeviceManagementConfigurationIntegerSettingValueDefinitionTemplate build() {
            DeviceManagementConfigurationIntegerSettingValueDefinitionTemplate _x = new DeviceManagementConfigurationIntegerSettingValueDefinitionTemplate();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementConfigurationIntegerSettingValueDefinitionTemplate";
            _x.maxValue = maxValue;
            _x.minValue = minValue;
            return _x;
        }
    }

    private DeviceManagementConfigurationIntegerSettingValueDefinitionTemplate _copy() {
        DeviceManagementConfigurationIntegerSettingValueDefinitionTemplate _x = new DeviceManagementConfigurationIntegerSettingValueDefinitionTemplate();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.maxValue = maxValue;
        _x.minValue = minValue;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationIntegerSettingValueDefinitionTemplate[");
        b.append("maxValue=");
        b.append(this.maxValue);
        b.append(", ");
        b.append("minValue=");
        b.append(this.minValue);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
