package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "maximumValue", 
    "minimumValue"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationIntegerSettingValueDefinition extends DeviceManagementConfigurationSettingValueDefinition implements ODataType {

    @JsonProperty("maximumValue")
    protected Long maximumValue;

    @JsonProperty("minimumValue")
    protected Long minimumValue;

    protected DeviceManagementConfigurationIntegerSettingValueDefinition() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationIntegerSettingValueDefinition";
    }

    /**
     * <i>“Maximum allowed value of the integer”</i>
     * 
     * @return property maximumValue
     */
    @Property(name="maximumValue")
    @JsonIgnore
    public Optional<Long> getMaximumValue() {
        return Optional.ofNullable(maximumValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code maximumValue}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Maximum allowed value of the integer”</i>
     * 
     * @param maximumValue
     *            new value of {@code maximumValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code maximumValue} field changed
     */
    public DeviceManagementConfigurationIntegerSettingValueDefinition withMaximumValue(Long maximumValue) {
        DeviceManagementConfigurationIntegerSettingValueDefinition _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationIntegerSettingValueDefinition");
        _x.maximumValue = maximumValue;
        return _x;
    }

    /**
     * <i>“Minimum allowed value of the integer”</i>
     * 
     * @return property minimumValue
     */
    @Property(name="minimumValue")
    @JsonIgnore
    public Optional<Long> getMinimumValue() {
        return Optional.ofNullable(minimumValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code minimumValue}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Minimum allowed value of the integer”</i>
     * 
     * @param minimumValue
     *            new value of {@code minimumValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumValue} field changed
     */
    public DeviceManagementConfigurationIntegerSettingValueDefinition withMinimumValue(Long minimumValue) {
        DeviceManagementConfigurationIntegerSettingValueDefinition _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationIntegerSettingValueDefinition");
        _x.minimumValue = minimumValue;
        return _x;
    }

    public DeviceManagementConfigurationIntegerSettingValueDefinition withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationIntegerSettingValueDefinition _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementConfigurationIntegerSettingValueDefinition() {
        return new Builder();
    }

    public static final class Builder {
        private Long maximumValue;
        private Long minimumValue;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Maximum allowed value of the integer”</i>
         * 
         * @param maximumValue
         *            value of {@code maximumValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder maximumValue(Long maximumValue) {
            this.maximumValue = maximumValue;
            this.changedFields = changedFields.add("maximumValue");
            return this;
        }

        /**
         * <i>“Minimum allowed value of the integer”</i>
         * 
         * @param minimumValue
         *            value of {@code minimumValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumValue(Long minimumValue) {
            this.minimumValue = minimumValue;
            this.changedFields = changedFields.add("minimumValue");
            return this;
        }

        public DeviceManagementConfigurationIntegerSettingValueDefinition build() {
            DeviceManagementConfigurationIntegerSettingValueDefinition _x = new DeviceManagementConfigurationIntegerSettingValueDefinition();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementConfigurationIntegerSettingValueDefinition";
            _x.maximumValue = maximumValue;
            _x.minimumValue = minimumValue;
            return _x;
        }
    }

    private DeviceManagementConfigurationIntegerSettingValueDefinition _copy() {
        DeviceManagementConfigurationIntegerSettingValueDefinition _x = new DeviceManagementConfigurationIntegerSettingValueDefinition();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.maximumValue = maximumValue;
        _x.minimumValue = minimumValue;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationIntegerSettingValueDefinition[");
        b.append("maximumValue=");
        b.append(this.maximumValue);
        b.append(", ");
        b.append("minimumValue=");
        b.append(this.minimumValue);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
