package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“Value of the GroupSetting”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "children"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationGroupSettingValue extends DeviceManagementConfigurationSettingValue implements ODataType {

    @JsonProperty("children")
    protected List<DeviceManagementConfigurationSettingInstance> children;

    @JsonProperty("children@nextLink")
    protected String childrenNextLink;

    protected DeviceManagementConfigurationGroupSettingValue() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationGroupSettingValue";
    }

    /**
     * <i>“Collection of child setting instances contained within this GroupSetting”</i>
     * 
     * @return property children
     */
    @Property(name="children")
    @JsonIgnore
    public CollectionPage<DeviceManagementConfigurationSettingInstance> getChildren() {
        return new CollectionPage<DeviceManagementConfigurationSettingInstance>(contextPath, DeviceManagementConfigurationSettingInstance.class, this.children, Optional.ofNullable(childrenNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Collection of child setting instances contained within this GroupSetting”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property children
     */
    @Property(name="children")
    @JsonIgnore
    public CollectionPage<DeviceManagementConfigurationSettingInstance> getChildren(HttpRequestOptions options) {
        return new CollectionPage<DeviceManagementConfigurationSettingInstance>(contextPath, DeviceManagementConfigurationSettingInstance.class, this.children, Optional.ofNullable(childrenNextLink), Collections.emptyList(), options);
    }

    public DeviceManagementConfigurationGroupSettingValue withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationGroupSettingValue _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementConfigurationGroupSettingValue() {
        return new Builder();
    }

    public static final class Builder {
        private DeviceManagementConfigurationSettingValueTemplateReference settingValueTemplateReference;
        private List<DeviceManagementConfigurationSettingInstance> children;
        private String childrenNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder settingValueTemplateReference(DeviceManagementConfigurationSettingValueTemplateReference settingValueTemplateReference) {
            this.settingValueTemplateReference = settingValueTemplateReference;
            this.changedFields = changedFields.add("settingValueTemplateReference");
            return this;
        }

        /**
         * <i>“Collection of child setting instances contained within this GroupSetting”</i>
         * 
         * @param children
         *            value of {@code children} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder children(List<DeviceManagementConfigurationSettingInstance> children) {
            this.children = children;
            this.changedFields = changedFields.add("children");
            return this;
        }

        /**
         * <i>“Collection of child setting instances contained within this GroupSetting”</i>
         * 
         * @param children
         *            value of {@code children} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder children(DeviceManagementConfigurationSettingInstance... children) {
            return children(Arrays.asList(children));
        }

        /**
         * <i>“Collection of child setting instances contained within this GroupSetting”</i>
         * 
         * @param childrenNextLink
         *            value of {@code children@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder childrenNextLink(String childrenNextLink) {
            this.childrenNextLink = childrenNextLink;
            this.changedFields = changedFields.add("children");
            return this;
        }

        public DeviceManagementConfigurationGroupSettingValue build() {
            DeviceManagementConfigurationGroupSettingValue _x = new DeviceManagementConfigurationGroupSettingValue();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementConfigurationGroupSettingValue";
            _x.settingValueTemplateReference = settingValueTemplateReference;
            _x.children = children;
            _x.childrenNextLink = childrenNextLink;
            return _x;
        }
    }

    private DeviceManagementConfigurationGroupSettingValue _copy() {
        DeviceManagementConfigurationGroupSettingValue _x = new DeviceManagementConfigurationGroupSettingValue();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.settingValueTemplateReference = settingValueTemplateReference;
        _x.children = children;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationGroupSettingValue[");
        b.append("settingValueTemplateReference=");
        b.append(this.settingValueTemplateReference);
        b.append(", ");
        b.append("children=");
        b.append(this.children);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
