package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Group Setting Instance Template”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "groupSettingValueTemplate"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationGroupSettingInstanceTemplate extends DeviceManagementConfigurationSettingInstanceTemplate implements ODataType {

    @JsonProperty("groupSettingValueTemplate")
    protected DeviceManagementConfigurationGroupSettingValueTemplate groupSettingValueTemplate;

    protected DeviceManagementConfigurationGroupSettingInstanceTemplate() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationGroupSettingInstanceTemplate";
    }

    /**
     * <i>“Group Setting Value Template”</i>
     * 
     * @return property groupSettingValueTemplate
     */
    @Property(name="groupSettingValueTemplate")
    @JsonIgnore
    public Optional<DeviceManagementConfigurationGroupSettingValueTemplate> getGroupSettingValueTemplate() {
        return Optional.ofNullable(groupSettingValueTemplate);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * groupSettingValueTemplate} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Group Setting Value Template”</i>
     * 
     * @param groupSettingValueTemplate
     *            new value of {@code groupSettingValueTemplate} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code groupSettingValueTemplate} field changed
     */
    public DeviceManagementConfigurationGroupSettingInstanceTemplate withGroupSettingValueTemplate(DeviceManagementConfigurationGroupSettingValueTemplate groupSettingValueTemplate) {
        DeviceManagementConfigurationGroupSettingInstanceTemplate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationGroupSettingInstanceTemplate");
        _x.groupSettingValueTemplate = groupSettingValueTemplate;
        return _x;
    }

    public DeviceManagementConfigurationGroupSettingInstanceTemplate withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationGroupSettingInstanceTemplate _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementConfigurationGroupSettingInstanceTemplate() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean isRequired;
        private String settingDefinitionId;
        private String settingInstanceTemplateId;
        private DeviceManagementConfigurationGroupSettingValueTemplate groupSettingValueTemplate;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder isRequired(Boolean isRequired) {
            this.isRequired = isRequired;
            this.changedFields = changedFields.add("isRequired");
            return this;
        }

        public Builder settingDefinitionId(String settingDefinitionId) {
            this.settingDefinitionId = settingDefinitionId;
            this.changedFields = changedFields.add("settingDefinitionId");
            return this;
        }

        public Builder settingInstanceTemplateId(String settingInstanceTemplateId) {
            this.settingInstanceTemplateId = settingInstanceTemplateId;
            this.changedFields = changedFields.add("settingInstanceTemplateId");
            return this;
        }

        /**
         * <i>“Group Setting Value Template”</i>
         * 
         * @param groupSettingValueTemplate
         *            value of {@code groupSettingValueTemplate} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupSettingValueTemplate(DeviceManagementConfigurationGroupSettingValueTemplate groupSettingValueTemplate) {
            this.groupSettingValueTemplate = groupSettingValueTemplate;
            this.changedFields = changedFields.add("groupSettingValueTemplate");
            return this;
        }

        public DeviceManagementConfigurationGroupSettingInstanceTemplate build() {
            DeviceManagementConfigurationGroupSettingInstanceTemplate _x = new DeviceManagementConfigurationGroupSettingInstanceTemplate();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementConfigurationGroupSettingInstanceTemplate";
            _x.isRequired = isRequired;
            _x.settingDefinitionId = settingDefinitionId;
            _x.settingInstanceTemplateId = settingInstanceTemplateId;
            _x.groupSettingValueTemplate = groupSettingValueTemplate;
            return _x;
        }
    }

    private DeviceManagementConfigurationGroupSettingInstanceTemplate _copy() {
        DeviceManagementConfigurationGroupSettingInstanceTemplate _x = new DeviceManagementConfigurationGroupSettingInstanceTemplate();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.isRequired = isRequired;
        _x.settingDefinitionId = settingDefinitionId;
        _x.settingInstanceTemplateId = settingInstanceTemplateId;
        _x.groupSettingValueTemplate = groupSettingValueTemplate;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationGroupSettingInstanceTemplate[");
        b.append("isRequired=");
        b.append(this.isRequired);
        b.append(", ");
        b.append("settingDefinitionId=");
        b.append(this.settingDefinitionId);
        b.append(", ");
        b.append("settingInstanceTemplateId=");
        b.append(this.settingInstanceTemplateId);
        b.append(", ");
        b.append("groupSettingValueTemplate=");
        b.append(this.groupSettingValueTemplate);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
