package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“Instance of a GroupSettingCollection”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "groupSettingCollectionValue"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationGroupSettingCollectionInstance extends DeviceManagementConfigurationSettingInstance implements ODataType {

    @JsonProperty("groupSettingCollectionValue")
    protected List<DeviceManagementConfigurationGroupSettingValue> groupSettingCollectionValue;

    @JsonProperty("groupSettingCollectionValue@nextLink")
    protected String groupSettingCollectionValueNextLink;

    protected DeviceManagementConfigurationGroupSettingCollectionInstance() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationGroupSettingCollectionInstance";
    }

    /**
     * <i>“A collection of GroupSetting values”</i>
     * 
     * @return property groupSettingCollectionValue
     */
    @Property(name="groupSettingCollectionValue")
    @JsonIgnore
    public CollectionPage<DeviceManagementConfigurationGroupSettingValue> getGroupSettingCollectionValue() {
        return new CollectionPage<DeviceManagementConfigurationGroupSettingValue>(contextPath, DeviceManagementConfigurationGroupSettingValue.class, this.groupSettingCollectionValue, Optional.ofNullable(groupSettingCollectionValueNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“A collection of GroupSetting values”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property groupSettingCollectionValue
     */
    @Property(name="groupSettingCollectionValue")
    @JsonIgnore
    public CollectionPage<DeviceManagementConfigurationGroupSettingValue> getGroupSettingCollectionValue(HttpRequestOptions options) {
        return new CollectionPage<DeviceManagementConfigurationGroupSettingValue>(contextPath, DeviceManagementConfigurationGroupSettingValue.class, this.groupSettingCollectionValue, Optional.ofNullable(groupSettingCollectionValueNextLink), Collections.emptyList(), options);
    }

    public DeviceManagementConfigurationGroupSettingCollectionInstance withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationGroupSettingCollectionInstance _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementConfigurationGroupSettingCollectionInstance() {
        return new Builder();
    }

    public static final class Builder {
        private String settingDefinitionId;
        private DeviceManagementConfigurationSettingInstanceTemplateReference settingInstanceTemplateReference;
        private List<DeviceManagementConfigurationGroupSettingValue> groupSettingCollectionValue;
        private String groupSettingCollectionValueNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder settingDefinitionId(String settingDefinitionId) {
            this.settingDefinitionId = settingDefinitionId;
            this.changedFields = changedFields.add("settingDefinitionId");
            return this;
        }

        public Builder settingInstanceTemplateReference(DeviceManagementConfigurationSettingInstanceTemplateReference settingInstanceTemplateReference) {
            this.settingInstanceTemplateReference = settingInstanceTemplateReference;
            this.changedFields = changedFields.add("settingInstanceTemplateReference");
            return this;
        }

        /**
         * <i>“A collection of GroupSetting values”</i>
         * 
         * @param groupSettingCollectionValue
         *            value of {@code groupSettingCollectionValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupSettingCollectionValue(List<DeviceManagementConfigurationGroupSettingValue> groupSettingCollectionValue) {
            this.groupSettingCollectionValue = groupSettingCollectionValue;
            this.changedFields = changedFields.add("groupSettingCollectionValue");
            return this;
        }

        /**
         * <i>“A collection of GroupSetting values”</i>
         * 
         * @param groupSettingCollectionValue
         *            value of {@code groupSettingCollectionValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupSettingCollectionValue(DeviceManagementConfigurationGroupSettingValue... groupSettingCollectionValue) {
            return groupSettingCollectionValue(Arrays.asList(groupSettingCollectionValue));
        }

        /**
         * <i>“A collection of GroupSetting values”</i>
         * 
         * @param groupSettingCollectionValueNextLink
         *            value of {@code groupSettingCollectionValue@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupSettingCollectionValueNextLink(String groupSettingCollectionValueNextLink) {
            this.groupSettingCollectionValueNextLink = groupSettingCollectionValueNextLink;
            this.changedFields = changedFields.add("groupSettingCollectionValue");
            return this;
        }

        public DeviceManagementConfigurationGroupSettingCollectionInstance build() {
            DeviceManagementConfigurationGroupSettingCollectionInstance _x = new DeviceManagementConfigurationGroupSettingCollectionInstance();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementConfigurationGroupSettingCollectionInstance";
            _x.settingDefinitionId = settingDefinitionId;
            _x.settingInstanceTemplateReference = settingInstanceTemplateReference;
            _x.groupSettingCollectionValue = groupSettingCollectionValue;
            _x.groupSettingCollectionValueNextLink = groupSettingCollectionValueNextLink;
            return _x;
        }
    }

    private DeviceManagementConfigurationGroupSettingCollectionInstance _copy() {
        DeviceManagementConfigurationGroupSettingCollectionInstance _x = new DeviceManagementConfigurationGroupSettingCollectionInstance();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.settingDefinitionId = settingDefinitionId;
        _x.settingInstanceTemplateReference = settingInstanceTemplateReference;
        _x.groupSettingCollectionValue = groupSettingCollectionValue;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationGroupSettingCollectionInstance[");
        b.append("settingDefinitionId=");
        b.append(this.settingDefinitionId);
        b.append(", ");
        b.append("settingInstanceTemplateReference=");
        b.append(this.settingInstanceTemplateReference);
        b.append(", ");
        b.append("groupSettingCollectionValue=");
        b.append(this.groupSettingCollectionValue);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
